/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.couch.db;

import java.text.MessageFormat;
import java.util.IllegalFormatException;
import java.util.List;

public class CouchDBException
extends Exception {
    private static final long serialVersionUID = 1L;
    private List<? extends Throwable> nested;
    private final Object[] params;

    public CouchDBException(String message, Throwable error, Object ... params) {
        super(message, error);
        this.params = params;
    }

    public CouchDBException(String message, Object ... params) {
        super(message);
        this.params = params;
    }

    @Override
    public String getMessage() {
        StringBuilder msg = new StringBuilder(this.formatMessage());
        if (this.nested != null && !this.nested.isEmpty()) {
            msg.append("\nNested errors:\n");
            int idx = 1;
            for (Throwable throwable : this.nested) {
                msg.append("\n").append(idx).append(".  ").append(throwable.getMessage());
                ++idx;
            }
        }
        return msg.toString();
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public String formatMessage() {
        String message = super.getMessage();
        if (this.params != null) {
            try {
                message = String.format(message, this.params);
            }
            catch (IllegalFormatException ife) {
                try {
                    message = MessageFormat.format(message, this.params);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return message;
    }

    public CouchDBException withNestedErrors(List<? extends Throwable> errors) {
        this.nested = errors;
        return this;
    }
}

