/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.couch.db.action;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.concurrent.CountDownLatch;
import org.commonjava.couch.db.CouchDBException;
import org.commonjava.couch.db.CouchManager;
import org.commonjava.couch.db.action.CouchDocumentAction;
import org.commonjava.couch.model.AbstractCouchDocument;
import org.commonjava.couch.model.CouchDocument;

public class DeleteAction
implements CouchDocumentAction {
    private final CouchDocument document;
    private CouchDBException error;
    private CountDownLatch latch;
    private CouchManager manager;

    public DeleteAction(CouchDocument document) {
        this.document = new DeleteDoc(document);
    }

    public DeleteAction(String key, String revision) {
        this.document = new DeleteDoc(key, revision);
    }

    public DeleteAction(String key) {
        this.document = new DeleteDoc(key);
    }

    @Override
    public CouchDocument getDocument() {
        return this.document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.manager.delete(this.document);
        }
        catch (CouchDBException e) {
            this.error = e;
        }
        finally {
            this.latch.countDown();
        }
    }

    @Override
    public CouchDBException getError() {
        return this.error;
    }

    @Override
    public void prepareExecution(CountDownLatch latch, CouchManager manager) {
        this.manager = manager;
        this.latch = latch;
    }

    static final class DeleteDoc
    extends AbstractCouchDocument {
        @SerializedName(value="_deleted")
        @Expose(deserialize=false)
        private final boolean delete = true;

        DeleteDoc() {
        }

        DeleteDoc(CouchDocument doc) {
            this.setCouchDocId(doc.getCouchDocId());
            this.setCouchDocRev(doc.getCouchDocRev());
        }

        DeleteDoc(String id, String rev) {
            this.setCouchDocId(id);
            this.setCouchDocRev(rev);
        }

        DeleteDoc(String id) {
            this.setCouchDocId(id);
        }
    }
}

