/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.couch.db.action;

import java.util.concurrent.CountDownLatch;
import org.commonjava.couch.db.CouchDBException;
import org.commonjava.couch.db.CouchManager;
import org.commonjava.couch.db.action.CouchDocumentAction;
import org.commonjava.couch.model.CouchDocument;

public class StoreAction
implements CouchDocumentAction {
    private final CouchDocument document;
    private final boolean skipIfExists;
    private CouchManager manager;
    private CountDownLatch latch;
    private CouchDBException error;

    public StoreAction(CouchDocument document, boolean skipIfExists) {
        this.document = document;
        this.skipIfExists = skipIfExists;
    }

    @Override
    public CouchDocument getDocument() {
        return this.document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.manager.store(this.document, this.skipIfExists);
        }
        catch (CouchDBException e) {
            this.error = e;
        }
        finally {
            this.latch.countDown();
        }
    }

    @Override
    public CouchDBException getError() {
        return this.error;
    }

    @Override
    public void prepareExecution(CountDownLatch latch, CouchManager manager) {
        this.manager = manager;
        this.latch = latch;
    }
}

