/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.couch.db.model;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.commonjava.couch.db.CouchDBException;
import org.commonjava.couch.io.CouchHttpClient;
import org.commonjava.couch.model.Attachment;

public class AttachmentDownload
implements Attachment {
    private final HttpResponse response;
    private final CouchHttpClient client;
    private final String name;
    private final HttpGet request;

    public AttachmentDownload(String name, HttpGet request, HttpResponse response, CouchHttpClient client) throws CouchDBException {
        try {
            if (response.getEntity() == null || response.getEntity().getContent() == null) {
                throw new CouchDBException("Invalid attachment; response contained no data: %s", name);
            }
        }
        catch (IOException e) {
            throw new CouchDBException("Invalid attachment; response data cannot be read for: %s. Reason: %s", (Throwable)e, name, e.getMessage());
        }
        this.name = name;
        this.request = request;
        this.response = response;
        this.client = client;
    }

    @Override
    public InputStream getData() throws IOException {
        return new ConnectionManagingInputStream();
    }

    @Override
    public long getContentLength() {
        return this.response.getEntity().getContentLength();
    }

    @Override
    public String getContentType() {
        Header[] headers = this.response.getHeaders("Content-Type");
        if (headers != null && headers.length > 0) {
            return headers[0].getValue();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void close() throws IOException {
        this.client.cleanup((HttpRequestBase)this.request);
    }

    private final class ConnectionManagingInputStream
    extends InputStream {
        InputStream stream;

        public ConnectionManagingInputStream() throws IOException {
            this.stream = AttachmentDownload.this.response.getEntity().getContent();
        }

        @Override
        public int read() throws IOException {
            return this.stream.read();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                super.close();
                this.stream.close();
            }
            finally {
                AttachmentDownload.this.client.cleanup((HttpRequestBase)AttachmentDownload.this.request);
            }
        }
    }
}

