/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.couch.io;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.commonjava.couch.conf.CouchDBConfiguration;
import org.commonjava.couch.db.CouchDBException;
import org.commonjava.couch.db.handler.ResponseHandlerWithError;
import org.commonjava.couch.db.handler.SerializedGetHandler;
import org.commonjava.couch.io.Serializer;
import org.commonjava.couch.io.json.SerializationAdapter;
import org.commonjava.couch.model.CouchError;

@Singleton
public class CouchHttpClient {
    private HttpClient client;
    @Inject
    private CouchDBConfiguration config;
    @Inject
    private Serializer serializer;

    public CouchHttpClient() {
    }

    public CouchHttpClient(CouchDBConfiguration config, Serializer serializer) {
        this.config = config;
        this.serializer = serializer;
        this.setupClient();
    }

    @PostConstruct
    private void setupClient() {
        ThreadSafeClientConnManager ccm = new ThreadSafeClientConnManager();
        ccm.setMaxTotal(this.config.getMaxConnections());
        DefaultHttpClient c = new DefaultHttpClient((ClientConnectionManager)ccm);
        if (this.config.getDatabaseUser() != null) {
            AuthScope scope = new AuthScope(this.config.getDatabaseHost(), this.config.getDatabasePort());
            UsernamePasswordCredentials cred = new UsernamePasswordCredentials(this.config.getDatabaseUser(), this.config.getDatabasePassword());
            c.getCredentialsProvider().setCredentials(scope, (Credentials)cred);
        }
        this.client = c;
    }

    public void executeHttp(HttpRequestBase request, String failureMessage) throws CouchDBException {
        this.executeHttp(request, null, failureMessage);
    }

    public void executeHttp(HttpRequestBase request, Integer expectedStatus, Object failureMessage) throws CouchDBException {
        String url = request.getURI().toString();
        try {
            HttpResponse response = this.client.execute((HttpUriRequest)request);
            StatusLine statusLine = response.getStatusLine();
            if (expectedStatus != null && statusLine.getStatusCode() != expectedStatus.intValue()) {
                HttpEntity entity = response.getEntity();
                CouchError error = this.serializer.toError(entity);
                throw new CouchDBException("%s: %s.\nHTTP Response: %s\nError: %s", failureMessage, url, statusLine, error);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new CouchDBException("%s: %s.\nReason: %s", (Throwable)e, failureMessage, url, e.getMessage());
        }
        catch (ClientProtocolException e) {
            throw new CouchDBException("%s: %s.\nReason: %s", (Throwable)e, failureMessage, url, e.getMessage());
        }
        catch (IOException e) {
            throw new CouchDBException("%s: %s.\nReason: %s", (Throwable)e, failureMessage, url, e.getMessage());
        }
        finally {
            this.cleanup(request);
        }
    }

    public HttpResponse executeHttpWithResponse(HttpRequestBase request, String failureMessage) throws CouchDBException {
        return this.executeHttpWithResponse(request, null, failureMessage);
    }

    public HttpResponse executeHttpWithResponse(HttpRequestBase request, Integer expectedStatus, Object failureMessage) throws CouchDBException {
        String url = request.getURI().toString();
        boolean failed = false;
        try {
            HttpResponse response = this.client.execute((HttpUriRequest)request);
            StatusLine statusLine = response.getStatusLine();
            if (expectedStatus != null && statusLine.getStatusCode() != expectedStatus.intValue()) {
                HttpEntity entity = response.getEntity();
                CouchError error = this.serializer.toError(entity);
                throw new CouchDBException("%s: %s.\nHTTP Response: %s\nError: %s", failureMessage, url, statusLine, error);
            }
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        catch (UnsupportedEncodingException e) {
            failed = true;
            throw new CouchDBException("%s: %s.\nReason: %s", (Throwable)e, failureMessage, url, e.getMessage());
        }
        catch (ClientProtocolException e) {
            failed = true;
            throw new CouchDBException("%s: %s.\nReason: %s", (Throwable)e, failureMessage, url, e.getMessage());
        }
        catch (IOException e) {
            failed = true;
            throw new CouchDBException("%s: %s.\nReason: %s", (Throwable)e, failureMessage, url, e.getMessage());
        }
        finally {
            if (failed) {
                this.cleanup(request);
            }
        }
    }

    public <T> T executeHttpAndReturn(HttpRequestBase request, Type type, Object failureMessage, SerializationAdapter ... adapters) throws CouchDBException {
        return this.executeHttpAndReturn(request, new SerializedGetHandler(this.serializer, type, adapters), failureMessage);
    }

    public <T> T executeHttpAndReturn(HttpRequestBase request, ResponseHandlerWithError<T> handler, Object failureMessage) throws CouchDBException {
        String url = request.getURI().toString();
        try {
            Object result = this.client.execute((HttpUriRequest)request, handler);
            if (result == null && handler.getError() != null) {
                throw handler.getError();
            }
            Object object = result;
            return (T)object;
        }
        catch (UnsupportedEncodingException e) {
            throw new CouchDBException("%s: %s.\nReason: %s", (Throwable)e, failureMessage, url, e.getMessage());
        }
        catch (ClientProtocolException e) {
            throw new CouchDBException("%s: %s.\nReason: %s", (Throwable)e, failureMessage, url, e.getMessage());
        }
        catch (IOException e) {
            throw new CouchDBException("%s: %s.\nReason: %s", (Throwable)e, failureMessage, url, e.getMessage());
        }
        finally {
            this.cleanup(request);
        }
    }

    public void cleanup(HttpRequestBase request) {
        request.abort();
        this.client.getConnectionManager().closeExpiredConnections();
        this.client.getConnectionManager().closeIdleConnections(2L, TimeUnit.SECONDS);
    }
}

