/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.couch.io;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Singleton;
import org.apache.http.HttpEntity;
import org.commonjava.couch.db.action.BulkActionHolder;
import org.commonjava.couch.db.action.CouchDocumentAction;
import org.commonjava.couch.io.json.CouchDocumentActionAdapter;
import org.commonjava.couch.io.json.SerializationAdapter;
import org.commonjava.couch.model.CouchDocument;
import org.commonjava.couch.model.CouchError;

@Singleton
public class Serializer {
    private final Set<SerializationAdapter> baseAdapters = new HashSet<SerializationAdapter>();

    Serializer() {
    }

    public Serializer(SerializationAdapter ... baseAdapters) {
        this.baseAdapters.addAll(Arrays.asList(baseAdapters));
    }

    public void registerSerializationAdapters(SerializationAdapter ... adapters) {
        this.baseAdapters.addAll(Arrays.asList(adapters));
    }

    public String toString(BulkActionHolder actions, SerializationAdapter ... adapters) {
        return this.getGson(adapters).toJson((Object)actions);
    }

    public String toString(CouchDocument doc, SerializationAdapter ... adapters) {
        return this.getGson(adapters).toJson((Object)doc);
    }

    public <D extends CouchDocument> D toDocument(String src, Class<D> docType, SerializationAdapter ... adapters) {
        return (D)((CouchDocument)this.getGson(adapters).fromJson(src, docType));
    }

    public <D extends CouchDocument> D toDocument(InputStream src, String encoding, Class<D> docType, SerializationAdapter ... adapters) throws UnsupportedEncodingException {
        return (D)((CouchDocument)this.getGson(adapters).fromJson((Reader)new InputStreamReader(src, encoding), docType));
    }

    public <T> T fromJson(String src, Type type, SerializationAdapter ... adapters) {
        return (T)this.getGson(adapters).fromJson(src, type);
    }

    public <T> T fromJson(InputStream src, String encoding, Type type, SerializationAdapter ... adapters) throws UnsupportedEncodingException {
        return (T)this.getGson(adapters).fromJson((Reader)new InputStreamReader(src, encoding), type);
    }

    public CouchError toError(InputStream in, String charset) throws UnsupportedEncodingException {
        InputStreamReader reader = new InputStreamReader(in, charset);
        return (CouchError)this.getGson(new SerializationAdapter[0]).fromJson((Reader)reader, CouchError.class);
    }

    public CouchError toError(HttpEntity entity) throws IOException {
        if (entity == null) {
            return null;
        }
        if (entity.getContentEncoding() != null) {
            System.out.printf("Content-Encoding header: '%s' = '%s'\n", entity.getContentEncoding().getName(), entity.getContentEncoding().getValue());
        }
        InputStreamReader reader = new InputStreamReader(entity.getContent());
        return (CouchError)this.getGson(new SerializationAdapter[0]).fromJson((Reader)reader, CouchError.class);
    }

    protected GsonBuilder newGsonBuilder() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(CouchDocumentAction.class, (Object)new CouchDocumentActionAdapter());
        return builder;
    }

    protected final Gson getGson(SerializationAdapter ... adapters) {
        GsonBuilder builder = this.newGsonBuilder();
        if (this.baseAdapters != null) {
            for (SerializationAdapter adapter : this.baseAdapters) {
                builder.registerTypeAdapter(adapter.typeLiteral(), (Object)adapter);
            }
        }
        if (adapters != null) {
            for (SerializationAdapter adapter : adapters) {
                builder.registerTypeAdapter(adapter.typeLiteral(), (Object)adapter);
            }
        }
        return builder.create();
    }
}

