/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.couch.io.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.commonjava.couch.db.model.CouchObjectList;
import org.commonjava.couch.io.json.SerializationAdapter;
import org.commonjava.couch.model.CouchDocument;

public class CouchObjectListDeserializer<T extends CouchDocument>
implements JsonDeserializer<CouchObjectList<T>>,
SerializationAdapter {
    private static final String ROWS = "rows";
    private static final String DOC_ELEMENT = "doc";
    private final Class<T> type;

    public CouchObjectListDeserializer(Class<T> type) {
        this.type = type;
    }

    @Override
    public Type typeLiteral() {
        return new TypeToken<CouchObjectList<T>>(){}.getType();
    }

    public CouchObjectList<T> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ArrayList<T> items = new ArrayList<T>();
        JsonElement rowsRaw = json.getAsJsonObject().get(ROWS);
        if (rowsRaw == null) {
            throw new JsonParseException("Cannot find rows field within root object.");
        }
        JsonArray rows = rowsRaw.getAsJsonArray();
        for (JsonElement row : rows) {
            JsonObject rowObj = row.getAsJsonObject();
            JsonElement doc = rowObj.get(DOC_ELEMENT);
            if (doc == null) {
                throw new JsonParseException("Cannot find doc field within row: " + row + "\nDid you access the view with the '?include_docs=true' query parameter?");
            }
            items.add(this.type.cast(context.deserialize(doc, this.type)));
        }
        return new CouchObjectList(items);
    }
}

