/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.couch.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.commonjava.couch.db.model.AppDescription;
import org.commonjava.couch.model.AbstractCouchDocument;
import org.commonjava.couch.model.CouchAppView;

public class CouchApp
extends AbstractCouchDocument {
    private static final String DEFAULT_LANGUAGE = "javascript";
    private static final String DESIGN_PREFIX = "_design/";
    private String language = "javascript";
    private Map<String, CouchAppView> views;
    private final transient AppDescription description;

    public CouchApp(String id, Map<String, CouchAppView> views, AppDescription description) {
        this.description = description;
        this.setCouchDocId(DESIGN_PREFIX + id);
        this.views = views;
    }

    public CouchApp(String id, AppDescription description) {
        this.description = description;
        this.setCouchDocId(DESIGN_PREFIX + id);
        this.views = new HashMap<String, CouchAppView>();
    }

    public String getLanguage() {
        return this.language;
    }

    void setLanguage(String language) {
        this.language = language;
    }

    public synchronized CouchAppView addView(String name, CouchAppView view) {
        if (this.views == null) {
            this.views = new HashMap<String, CouchAppView>();
        }
        return this.views.put(name, view);
    }

    public Map<String, CouchAppView> getViews() {
        return this.views;
    }

    void setViews(Map<String, CouchAppView> views) {
        this.views = views;
    }

    public String toString() {
        return String.format("CouchApp [id=%s]\nViews:\n\n%s", this.getCouchDocId(), StringUtils.join(this.views.keySet(), (String)"\n"));
    }

    public AppDescription getDescription() {
        return this.description;
    }
}

