/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.couch.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.commonjava.couch.model.Attachment;

public class FileAttachment
implements Attachment {
    private final File data;
    private final String name;
    private final String contentType;
    private final long contentLength;
    private transient FileInputStream stream;

    public FileAttachment(String name, File data, String contentType, long contentLength) {
        this.name = name;
        this.data = data;
        this.contentType = contentType;
        this.contentLength = contentLength;
    }

    @Override
    public synchronized InputStream getData() throws IOException {
        if (this.stream == null) {
            this.stream = new FileInputStream(this.data);
        }
        return this.stream;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
    }
}

