/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.couch.util;

import org.commonjava.util.logging.Logger;

public class ChangeSynchronizer {
    private final Logger logger = new Logger(this.getClass());
    private boolean changed = false;

    public synchronized void setChanged() {
        this.changed = true;
        this.notifyAll();
    }

    public void resetChanged() {
        this.changed = false;
    }

    public synchronized void waitForChange(long totalMillis, long pollMillis) {
        long start = System.currentTimeMillis();
        double runningTotal = 0.0;
        while (!this.changed) {
            runningTotal = System.currentTimeMillis() - start;
            this.logger.debug("Waited (%s ms)...", new Object[]{runningTotal});
            if (runningTotal > (double)totalMillis) {
                this.logger.debug("Wait (%s ms) expired.", new Object[]{totalMillis});
                break;
            }
            try {
                this.logger.debug("Waiting (%s ms) for changes.", new Object[]{pollMillis});
                this.wait(pollMillis);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        if (this.changed) {
            this.logger.debug("Setting changed state to false.", new Object[0]);
            this.changed = false;
        }
        this.logger.debug("waitFoChange() exiting.", new Object[0]);
    }
}

