/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.couch.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public final class UrlUtils {
    private UrlUtils() {
    }

    public static String stringQueryParameter(Object value) {
        String base = String.valueOf(value);
        return "%22" + base + "%22";
    }

    public static String buildUrl(String baseUrl, String ... parts) throws MalformedURLException {
        return UrlUtils.buildUrl(baseUrl, null, parts);
    }

    public static String buildUrl(String baseUrl, Map<String, String> params, String ... parts) throws MalformedURLException {
        if (parts == null || parts.length < 1) {
            return baseUrl;
        }
        StringBuilder urlBuilder = new StringBuilder();
        if (!parts[0].startsWith(baseUrl)) {
            urlBuilder.append(baseUrl);
        }
        for (String part : parts) {
            if (part.startsWith("/")) {
                part = part.substring(1);
            }
            if (urlBuilder.length() > 0 && urlBuilder.charAt(urlBuilder.length() - 1) != '/') {
                urlBuilder.append("/");
            }
            urlBuilder.append(part);
        }
        if (params != null && !params.isEmpty()) {
            urlBuilder.append("?");
            boolean first = true;
            for (Map.Entry<String, String> param : params.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    urlBuilder.append("&");
                }
                urlBuilder.append(param.getKey()).append("=").append(param.getValue());
            }
        }
        return new URL(urlBuilder.toString()).toExternalForm();
    }

    public static UrlInfo parseUrlInfo(String url) {
        return new UrlInfo(url);
    }

    public static final class UrlInfo {
        private final String url;
        private String user;
        private String password;
        private final String host;
        private int port;

        private UrlInfo(String u) {
            URL url;
            String resultUrl = u;
            try {
                url = new URL(u);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Failed to parse repository URL: '" + u + "'. Reason: " + e.getMessage(), e);
            }
            String userInfo = url.getUserInfo();
            if (userInfo != null && this.user == null && this.password == null) {
                this.user = userInfo;
                this.password = null;
                int idx = userInfo.indexOf(58);
                if (idx > 0) {
                    this.user = userInfo.substring(0, idx);
                    this.password = userInfo.substring(idx + 1);
                    StringBuilder sb = new StringBuilder();
                    idx = this.url.indexOf("://");
                    sb.append(this.url.substring(0, idx + 3));
                    idx = this.url.indexOf("@");
                    if (idx > 0) {
                        sb.append(this.url.substring(idx + 1));
                    }
                    resultUrl = sb.toString();
                }
            }
            this.url = resultUrl;
            this.host = url.getHost();
            this.port = url.getPort() < 0 ? (url.getProtocol().equals("https") ? 443 : 80) : url.getPort();
        }

        public String getUrl() {
            return this.url;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }
    }
}

