/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.couch.change.dispatch;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.commonjava.couch.change.CouchDocChange;
import org.commonjava.couch.change.dispatch.CouchChangeDispatcher;
import org.commonjava.couch.change.dispatch.ThreadableListener;

public class ThreadedChangeDispatcher
implements CouchChangeDispatcher {
    private final Executor executor;
    private final List<? extends ThreadableListener> listeners;
    private final Set<ListenerRunnable> pendingDispatches = new LinkedHashSet<ListenerRunnable>();

    public ThreadedChangeDispatcher(List<? extends ThreadableListener> listeners, Executor executor) {
        this.listeners = listeners;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void documentChanged(CouchDocChange change) {
        for (ThreadableListener threadableListener : this.listeners) {
            if (!threadableListener.canProcess(change.getId(), change.isDeleted())) continue;
            ListenerRunnable run = new ListenerRunnable(threadableListener, change);
            ThreadedChangeDispatcher threadedChangeDispatcher = this;
            synchronized (threadedChangeDispatcher) {
                this.pendingDispatches.add(run);
            }
            this.executor.execute(run);
        }
    }

    public int getPendingCount() {
        return this.pendingDispatches.size();
    }

    private final class ListenerRunnable
    implements Runnable {
        private final ThreadableListener listener;
        private final CouchDocChange change;

        ListenerRunnable(ThreadableListener listener, CouchDocChange change) {
            this.listener = listener;
            this.change = change;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.listener.documentChanged(this.change);
            ThreadedChangeDispatcher threadedChangeDispatcher = ThreadedChangeDispatcher.this;
            synchronized (threadedChangeDispatcher) {
                ThreadedChangeDispatcher.this.pendingDispatches.remove(this);
                ThreadedChangeDispatcher.this.notifyAll();
            }
        }
    }
}

