/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.couch.conf;

import javax.enterprise.inject.Alternative;
import org.commonjava.couch.conf.CouchDBConfiguration;
import org.commonjava.couch.util.UrlUtils;
import org.commonjava.web.config.annotation.ConfigName;
import org.commonjava.web.config.annotation.SectionName;

@SectionName(value="database")
@Alternative
public class DefaultCouchDBConfiguration
implements CouchDBConfiguration {
    private static final int DEFAULT_MAX_CONNECTIONS = 20;
    private UrlUtils.UrlInfo urlInfo;
    private int maxConnections;

    public DefaultCouchDBConfiguration(String dbUrl, int maxConnections) {
        this.urlInfo = UrlUtils.parseUrlInfo(dbUrl);
        this.maxConnections = maxConnections;
    }

    public DefaultCouchDBConfiguration(String dbUrl) {
        this.urlInfo = UrlUtils.parseUrlInfo(dbUrl);
        this.maxConnections = -1;
    }

    public DefaultCouchDBConfiguration() {
    }

    @ConfigName(value="url")
    public void setDatabaseUrl(String databaseUrl) {
        this.urlInfo = UrlUtils.parseUrlInfo(databaseUrl);
    }

    @ConfigName(value="connections.max")
    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    @Override
    public String getDatabaseUrl() {
        return this.urlInfo.getUrl();
    }

    @Override
    public String getDatabaseUser() {
        return this.urlInfo.getUser();
    }

    @Override
    public String getDatabasePassword() {
        return this.urlInfo.getPassword();
    }

    @Override
    public String getDatabaseHost() {
        return this.urlInfo.getHost();
    }

    @Override
    public int getDatabasePort() {
        return this.urlInfo.getPort();
    }

    @Override
    public int getMaxConnections() {
        return this.maxConnections < 1 ? 20 : this.maxConnections;
    }
}

