/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.couch.db;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.log4j.Logger;
import org.commonjava.couch.change.j2ee.ApplicationEvent;
import org.commonjava.couch.change.j2ee.DatabaseEvent;
import org.commonjava.couch.conf.CouchDBConfiguration;
import org.commonjava.couch.db.CouchDBException;
import org.commonjava.couch.db.action.BulkActionHolder;
import org.commonjava.couch.db.action.CouchDocumentAction;
import org.commonjava.couch.db.action.DeleteAction;
import org.commonjava.couch.db.action.StoreAction;
import org.commonjava.couch.db.handler.SerializedGetHandler;
import org.commonjava.couch.db.model.AppDescription;
import org.commonjava.couch.db.model.AttachmentDownload;
import org.commonjava.couch.db.model.CouchObjectList;
import org.commonjava.couch.db.model.ViewRequest;
import org.commonjava.couch.io.CouchAppReader;
import org.commonjava.couch.io.CouchHttpClient;
import org.commonjava.couch.io.Serializer;
import org.commonjava.couch.io.json.CouchObjectListDeserializer;
import org.commonjava.couch.io.json.SerializationAdapter;
import org.commonjava.couch.model.Attachment;
import org.commonjava.couch.model.CouchApp;
import org.commonjava.couch.model.CouchDocRef;
import org.commonjava.couch.model.CouchDocument;
import org.commonjava.couch.model.CouchError;
import org.commonjava.couch.model.DenormalizedCouchDoc;
import org.commonjava.couch.util.ToString;
import org.commonjava.couch.util.UrlUtils;

public class CouchManager {
    private static final Logger LOGGER = Logger.getLogger(CouchManager.class);
    private static final String REV = "rev";
    private static final String VIEW_BASE = "_view";
    private static final String APP_BASE = "_design";
    private static final String BULK_DOCS = "_bulk_docs";
    private final ExecutorService exec = Executors.newCachedThreadPool();
    private final CouchAppReader appReader;
    @Inject
    private CouchDBConfiguration config;
    @Inject
    private CouchHttpClient client;
    @Inject
    private Event<DatabaseEvent> dbEvent;
    @Inject
    private Event<ApplicationEvent> appEvent;
    @Inject
    private Serializer serializer;

    protected CouchManager() {
        this.appReader = new CouchAppReader();
    }

    public CouchManager(CouchDBConfiguration config, CouchHttpClient client, Serializer serializer, CouchAppReader appReader) {
        this.config = config;
        this.client = client;
        this.serializer = serializer;
        this.appReader = appReader;
    }

    public CouchManager(CouchDBConfiguration config) {
        this.config = config;
        this.serializer = new Serializer(new SerializationAdapter[0]);
        this.appReader = new CouchAppReader();
        this.client = new CouchHttpClient(config, this.serializer);
    }

    public void initialize(AppDescription description) throws CouchDBException {
        CouchApp app;
        try {
            app = this.appReader.readAppDefinition(description);
        }
        catch (IOException e) {
            throw new CouchDBException("Failed to retrieve application definition: %s. Reason: %s", (Throwable)e, description.getClasspathAppResource(), e.getMessage());
        }
        if (!this.dbExists()) {
            this.createDatabase();
        } else {
            LOGGER.info((Object)("Database already exists: " + this.config.getDatabaseUrl()));
        }
        if (!this.appExists(description.getAppName())) {
            this.installApplication(app);
        } else {
            LOGGER.info((Object)("App: " + app.getCouchDocId() + " already exists in db: " + this.config.getDatabaseUrl()));
        }
    }

    public void store(Collection<? extends CouchDocument> documents, boolean skipIfExists, boolean allOrNothing) throws CouchDBException {
        HashSet<StoreAction> toStore = new HashSet<StoreAction>();
        for (CouchDocument couchDocument : documents) {
            if (couchDocument instanceof DenormalizedCouchDoc) {
                ((DenormalizedCouchDoc)((Object)couchDocument)).calculateDenormalizedFields();
            }
            if (skipIfExists && this.documentRevisionExists(couchDocument)) continue;
            toStore.add(new StoreAction(couchDocument, skipIfExists));
        }
        this.modify(toStore, allOrNothing);
    }

    public void delete(Collection<? extends CouchDocument> documents, boolean allOrNothing) throws CouchDBException {
        HashSet<DeleteAction> toDelete = new HashSet<DeleteAction>();
        for (CouchDocument couchDocument : documents) {
            if (couchDocument instanceof DenormalizedCouchDoc) {
                ((DenormalizedCouchDoc)((Object)couchDocument)).calculateDenormalizedFields();
            }
            if (!this.documentRevisionExists(couchDocument)) continue;
            toDelete.add(new DeleteAction(couchDocument));
        }
        this.modify(toDelete, allOrNothing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(Collection<? extends CouchDocumentAction> actions, boolean allOrNothing) throws CouchDBException {
        block14: {
            String url;
            for (CouchDocumentAction couchDocumentAction : actions) {
                CouchDocument doc = couchDocumentAction.getDocument();
                if (!(doc instanceof DenormalizedCouchDoc)) continue;
                ((DenormalizedCouchDoc)((Object)doc)).calculateDenormalizedFields();
            }
            BulkActionHolder bulk = new BulkActionHolder(actions, allOrNothing);
            String string = this.serializer.toString(bulk, new SerializationAdapter[0]);
            try {
                url = UrlUtils.buildUrl(this.config.getDatabaseUrl(), (Map<String, String>)null, BULK_DOCS);
            }
            catch (MalformedURLException e) {
                throw new CouchDBException("Failed to format bulk-update URL: %s", (Throwable)e, e.getMessage());
            }
            HttpPost request = new HttpPost(url);
            try {
                request.setEntity((HttpEntity)new StringEntity(string, "application/json", "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new CouchDBException("Failed to encode POST entity for bulk update: %s", (Throwable)e, e.getMessage());
            }
            try {
                HttpResponse response = this.client.executeHttpWithResponse((HttpRequestBase)request, "Bulk update failed");
                StatusLine statusLine = response.getStatusLine();
                int code = statusLine.getStatusCode();
                if (code == 200 || code == 201) break block14;
                String content = null;
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    InputStream in = null;
                    try {
                        in = entity.getContent();
                        IOUtils.copy((InputStream)in, (OutputStream)baos);
                    }
                    catch (IOException e) {
                        throw new CouchDBException("Error reading response content for error: %s\nError was: %s", (Throwable)e, statusLine, e.getMessage());
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)in);
                    }
                    content = new String(baos.toByteArray());
                }
                throw new CouchDBException("Bulk operation failed. Status line: %s\nContent:\n----------\n\n%s", statusLine, content);
            }
            finally {
                this.client.cleanup((HttpRequestBase)request);
            }
        }
    }

    public <T extends CouchDocument> List<T> getViewListing(ViewRequest req, Class<T> itemType) throws CouchDBException {
        req.setParameter("include_docs", true);
        String url = this.buildViewUrl(req);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Retrieving view listing from: " + url));
        }
        HttpGet request = new HttpGet(url);
        CouchObjectListDeserializer<T> deser = new CouchObjectListDeserializer<T>(itemType);
        CouchObjectList listing = (CouchObjectList)this.client.executeHttpAndReturn((HttpRequestBase)request, deser.typeLiteral(), new ToString("Failed to retrieve contents for view request: %s", req), deser);
        for (CouchDocument t : listing) {
            if (!(t instanceof DenormalizedCouchDoc)) continue;
            ((DenormalizedCouchDoc)((Object)t)).calculateDenormalizedFields();
        }
        return listing.getItems();
    }

    public <V> V getView(ViewRequest req, Class<V> type) throws CouchDBException {
        String url = this.buildViewUrl(req);
        HttpGet request = new HttpGet(url);
        return (V)this.client.executeHttpAndReturn((HttpRequestBase)request, type, new ToString("Failed to retrieve contents for view request: %s", req), new SerializationAdapter[0]);
    }

    public <T> T getDocument(CouchDocRef ref, Class<T> docType) throws CouchDBException {
        if (!this.documentRevisionExists(ref)) {
            return null;
        }
        String url = this.buildDocUrl(ref, true);
        HttpGet get = new HttpGet(url);
        T result = this.client.executeHttpAndReturn((HttpRequestBase)get, new SerializedGetHandler<T>(this.serializer, docType), new ToString("Failed to retrieve document: %s", ref));
        if (result instanceof DenormalizedCouchDoc) {
            ((DenormalizedCouchDoc)result).calculateDenormalizedFields();
        }
        return result;
    }

    public boolean store(CouchDocument doc, boolean skipIfExists) throws CouchDBException {
        if (doc instanceof DenormalizedCouchDoc) {
            ((DenormalizedCouchDoc)((Object)doc)).calculateDenormalizedFields();
        }
        if (skipIfExists && this.documentRevisionExists(doc)) {
            return false;
        }
        HttpPost request = new HttpPost(this.config.getDatabaseUrl());
        try {
            request.setHeader("Referer", this.config.getDatabaseUrl());
            String src = this.serializer.toString(doc, new SerializationAdapter[0]);
            request.setEntity((HttpEntity)new StringEntity(src, "application/json", "UTF-8"));
            this.client.executeHttp((HttpRequestBase)request, 201, "Failed to store document");
        }
        catch (UnsupportedEncodingException e) {
            throw new CouchDBException("Failed to store document: %s.\nReason: %s", (Throwable)e, doc, e.getMessage());
        }
        return true;
    }

    public void delete(CouchDocument doc) throws CouchDBException {
        if (doc instanceof DenormalizedCouchDoc) {
            ((DenormalizedCouchDoc)((Object)doc)).calculateDenormalizedFields();
        }
        if (!this.documentRevisionExists(doc)) {
            return;
        }
        String url = this.buildDocUrl(doc, true);
        HttpDelete request = new HttpDelete(url);
        this.client.executeHttp((HttpRequestBase)request, 200, "Failed to delete document");
    }

    public void attach(CouchDocument doc, Attachment attachment) throws CouchDBException {
        String url;
        if (!this.documentRevisionExists(doc)) {
            throw new CouchDBException("Cannot attach to a non-existent document: %s", doc.getCouchDocId());
        }
        try {
            url = UrlUtils.buildUrl(this.config.getDatabaseUrl(), Collections.singletonMap(REV, doc.getCouchDocRev()), doc.getCouchDocId(), attachment.getName());
        }
        catch (MalformedURLException e) {
            throw new CouchDBException("Failed to format attachment URL for: %s to document: %s. Error: %s", (Throwable)e, attachment.getName(), doc.getCouchDocId(), e.getMessage());
        }
        LOGGER.info((Object)("Attaching " + attachment.getName() + " to document: " + doc.getCouchDocId() + "\nURL: " + url));
        HttpPut request = new HttpPut(url);
        request.setHeader("Content-Type", attachment.getContentType());
        try {
            request.setEntity((HttpEntity)new InputStreamEntity(attachment.getData(), attachment.getContentLength()));
        }
        catch (IOException e) {
            throw new CouchDBException("Failed to read attachment data: %s. Error: %s", (Throwable)e, attachment.getName(), e.getMessage());
        }
        this.client.executeHttp((HttpRequestBase)request, 201, "Failed to attach to document");
    }

    public void deleteAttachment(CouchDocument doc, String attachmentName) throws CouchDBException {
        String url;
        doc.setCouchDocRev(null);
        if (!this.documentRevisionExists(doc)) {
            throw new CouchDBException("Cannot delete attachment from a non-existent document: %s", doc.getCouchDocId());
        }
        try {
            url = UrlUtils.buildUrl(this.config.getDatabaseUrl(), Collections.singletonMap(REV, doc.getCouchDocRev()), doc.getCouchDocId(), attachmentName);
        }
        catch (MalformedURLException e) {
            throw new CouchDBException("Failed to format attachment URL for: %s to document: %s. Error: %s", (Throwable)e, attachmentName, doc.getCouchDocId(), e.getMessage());
        }
        HttpDelete request = new HttpDelete(url);
        this.client.executeHttp((HttpRequestBase)request, 200, "Failed to delete attachment");
    }

    public Attachment getAttachment(CouchDocument doc, String attachmentName) throws CouchDBException {
        String url;
        try {
            url = UrlUtils.buildUrl(this.config.getDatabaseUrl(), doc.getCouchDocId(), attachmentName);
        }
        catch (MalformedURLException e) {
            throw new CouchDBException("Failed to format attachment URL for: %s to document: %s. Error: %s", (Throwable)e, attachmentName, doc.getCouchDocId(), e.getMessage());
        }
        HttpGet request = new HttpGet(url);
        HttpResponse response = this.client.executeHttpWithResponse((HttpRequestBase)request, "Failed to retrieve attachment.");
        if (response.getStatusLine().getStatusCode() == 404) {
            return null;
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new CouchDBException("Failed to retrieve attachment: %s from: %s. Reason: %s", attachmentName, doc.getCouchDocId(), response.getStatusLine());
        }
        return new AttachmentDownload(attachmentName, request, response, this.client);
    }

    public boolean viewExists(String appName, String viewName) throws CouchDBException {
        try {
            return this.exists(UrlUtils.buildUrl(this.config.getDatabaseUrl(), (Map<String, String>)null, APP_BASE, appName, VIEW_BASE, viewName));
        }
        catch (MalformedURLException e) {
            throw new CouchDBException("Cannot format view URL for: %s in: %s. Reason: %s", (Throwable)e, viewName, appName, e.getMessage());
        }
        catch (CouchDBException e) {
            throw new CouchDBException("Cannot verify existence of view: %s in: %s. Reason: %s", (Throwable)e, viewName, appName, e.getMessage());
        }
    }

    public boolean appExists(String appName) throws CouchDBException {
        try {
            return this.exists(UrlUtils.buildUrl(this.config.getDatabaseUrl(), (Map<String, String>)null, APP_BASE, appName));
        }
        catch (MalformedURLException e) {
            throw new CouchDBException("Cannot format application URL: %s. Reason: %s", (Throwable)e, appName, e.getMessage());
        }
        catch (CouchDBException e) {
            throw new CouchDBException("Cannot verify existence of application: %s. Reason: %s", (Throwable)e, appName, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean documentRevisionExists(CouchDocument doc) throws CouchDBException {
        if (doc instanceof DenormalizedCouchDoc) {
            ((DenormalizedCouchDoc)((Object)doc)).calculateDenormalizedFields();
        }
        String docUrl = this.buildDocUrl(doc, doc.getCouchDocRev() != null);
        boolean exists = false;
        HttpHead request = new HttpHead(docUrl);
        try {
            HttpResponse response = this.client.executeHttpWithResponse((HttpRequestBase)request, "Failed to ping database URL");
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() == 200) {
                exists = true;
            } else if (statusLine.getStatusCode() != 404) {
                CouchError error;
                HttpEntity entity = response.getEntity();
                try {
                    error = this.serializer.toError(entity);
                }
                catch (IOException e) {
                    throw new CouchDBException("Failed to ping database URL: %s.\nReason: %s\nError: Cannot read error status: %s", (Throwable)e, docUrl, statusLine, e.getMessage());
                }
                throw new CouchDBException("Failed to ping database URL: %s.\nReason: %s\nError: %s", docUrl, statusLine, error);
            }
            if (exists) {
                Header etag = response.getFirstHeader("Etag");
                String rev = etag.getValue();
                if (rev.startsWith("\"") || rev.startsWith("'")) {
                    rev = rev.substring(1);
                }
                if (rev.endsWith("\"") || rev.endsWith("'")) {
                    rev = rev.substring(0, rev.length() - 1);
                }
                doc.setCouchDocRev(rev);
            }
        }
        finally {
            this.client.cleanup((HttpRequestBase)request);
        }
        return exists;
    }

    public boolean exists(CouchDocument doc) throws CouchDBException {
        if (doc instanceof DenormalizedCouchDoc) {
            ((DenormalizedCouchDoc)((Object)doc)).calculateDenormalizedFields();
        }
        String docUrl = this.buildDocUrl(doc, false);
        return this.exists(docUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String path) throws CouchDBException {
        boolean exists;
        block8: {
            String url;
            exists = false;
            try {
                url = UrlUtils.buildUrl(this.config.getDatabaseUrl(), path);
            }
            catch (MalformedURLException e) {
                throw new CouchDBException("Invalid path: %s. Reason: %s", (Throwable)e, path, e.getMessage());
            }
            HttpHead request = new HttpHead(url);
            try {
                CouchError error;
                HttpResponse response = this.client.executeHttpWithResponse((HttpRequestBase)request, "Failed to ping database URL");
                StatusLine statusLine = response.getStatusLine();
                if (statusLine.getStatusCode() == 200) {
                    exists = true;
                    break block8;
                }
                if (statusLine.getStatusCode() == 404) break block8;
                HttpEntity entity = response.getEntity();
                try {
                    error = this.serializer.toError(entity);
                }
                catch (IOException e) {
                    throw new CouchDBException("Failed to ping database URL: %s.\nReason: %s\nError: Cannot read error status: %s", (Throwable)e, url, statusLine, e.getMessage());
                }
                throw new CouchDBException("Failed to ping database URL: %s.\nReason: %s\nError: %s", url, statusLine, error);
            }
            finally {
                this.client.cleanup((HttpRequestBase)request);
            }
        }
        return exists;
    }

    public boolean dbExists() throws CouchDBException {
        return this.exists("/");
    }

    public void dropDatabase() throws CouchDBException {
        if (!this.dbExists()) {
            return;
        }
        HttpDelete request = new HttpDelete(this.config.getDatabaseUrl());
        this.client.executeHttp((HttpRequestBase)request, 200, "Failed to drop database");
        this.fireDBEvent(DatabaseEvent.Type.DROP, this.config.getDatabaseUrl());
    }

    public void createDatabase() throws CouchDBException {
        LOGGER.info((Object)("Creating database: " + this.config.getDatabaseUrl()));
        HttpPut request = new HttpPut(this.config.getDatabaseUrl());
        this.client.executeHttp((HttpRequestBase)request, 201, "Failed to create database");
        this.fireDBEvent(DatabaseEvent.Type.CREATE, this.config.getDatabaseUrl());
    }

    public void installApplication(CouchApp app) throws CouchDBException {
        String url = this.buildDocUrl(app, true);
        LOGGER.info((Object)("Installing app at: " + url));
        HttpPut request = new HttpPut(url);
        try {
            request.setHeader("Referer", this.config.getDatabaseUrl());
            String appJson = this.serializer.toString(app, new SerializationAdapter[0]);
            request.setEntity((HttpEntity)new StringEntity(appJson, "application/json", "UTF-8"));
            this.client.executeHttp((HttpRequestBase)request, 201, "Failed to store application document");
            this.fireAppEvent(ApplicationEvent.Type.INSTALL, app.getDescription());
        }
        catch (UnsupportedEncodingException e) {
            throw new CouchDBException("Failed to store application document: %s.\nReason: %s", (Throwable)e, app, e.getMessage());
        }
    }

    protected String buildViewUrl(ViewRequest req) throws CouchDBException {
        try {
            return UrlUtils.buildUrl(this.config.getDatabaseUrl(), req.getRequestParameters(), APP_BASE, req.getApplication(), VIEW_BASE, req.getView());
        }
        catch (MalformedURLException e) {
            throw new CouchDBException("Failed to format view URL for: %s.\nReason: %s", (Throwable)e, req, e.getMessage());
        }
    }

    protected String buildDocUrl(CouchDocument doc, boolean includeRevision) throws CouchDBException {
        if (doc instanceof DenormalizedCouchDoc) {
            ((DenormalizedCouchDoc)((Object)doc)).calculateDenormalizedFields();
        }
        try {
            String url;
            if (includeRevision && doc.getCouchDocRev() != null) {
                Map<String, String> params = Collections.singletonMap(REV, doc.getCouchDocRev());
                url = UrlUtils.buildUrl(this.config.getDatabaseUrl(), params, doc.getCouchDocId());
            } else {
                url = UrlUtils.buildUrl(this.config.getDatabaseUrl(), (Map<String, String>)null, doc.getCouchDocId());
            }
            return url;
        }
        catch (MalformedURLException e) {
            throw new CouchDBException("Failed to format document URL for id: %s [revision=%s].\nReason: %s", (Throwable)e, doc.getCouchDocId(), doc.getCouchDocRev(), e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void threadedExecute(Set<? extends CouchDocumentAction> actions) throws CouchDBException {
        CountDownLatch latch = new CountDownLatch(actions.size());
        for (CouchDocumentAction couchDocumentAction : actions) {
            couchDocumentAction.prepareExecution(latch, this);
            this.exec.execute(couchDocumentAction);
        }
        CountDownLatch i$ = latch;
        synchronized (i$) {
            while (latch.getCount() > 0L) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Waiting for " + latch.getCount() + " actions to complete."));
                }
                try {
                    latch.await(2L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
        }
        ArrayList<CouchDBException> errors = new ArrayList<CouchDBException>();
        for (CouchDocumentAction couchDocumentAction : actions) {
            if (couchDocumentAction.getError() == null) continue;
            errors.add(couchDocumentAction.getError());
        }
        if (!errors.isEmpty()) {
            throw new CouchDBException("Failed to execute %d actions.", errors.size()).withNestedErrors(errors);
        }
    }

    protected CouchAppReader getAppReader() {
        return this.appReader;
    }

    private void fireDBEvent(DatabaseEvent.Type type, String url) {
        if (this.dbEvent != null) {
            this.dbEvent.fire((Object)new DatabaseEvent(type, url));
        }
    }

    private void fireAppEvent(ApplicationEvent.Type type, AppDescription description) {
        if (this.appEvent != null) {
            this.appEvent.fire((Object)new ApplicationEvent(type, description));
        }
    }
}

