/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.couch.db.handler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.log4j.Logger;
import org.commonjava.couch.db.CouchDBException;
import org.commonjava.couch.db.handler.ResponseHandlerWithError;
import org.commonjava.couch.io.Serializer;
import org.commonjava.couch.io.json.SerializationAdapter;
import org.commonjava.couch.model.CouchError;

public class SerializedGetHandler<T>
implements ResponseHandlerWithError<T> {
    private static final Logger LOGGER = Logger.getLogger(SerializedGetHandler.class);
    private CouchDBException error;
    private final Serializer serializer;
    private final Type type;
    private final SerializationAdapter[] adapters;

    public SerializedGetHandler(Serializer serializer, Class<T> type) {
        this.serializer = serializer;
        this.type = type;
        this.adapters = new SerializationAdapter[0];
    }

    public SerializedGetHandler(Serializer serializer, Type type, SerializationAdapter ... adapters) {
        this.serializer = serializer;
        this.type = type;
        this.adapters = adapters;
    }

    @Override
    public CouchDBException getError() {
        return this.error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        block7: {
            HttpEntity entity = response.getEntity();
            ByteArrayOutputStream out = null;
            InputStream in = null;
            try {
                StatusLine sl;
                if (entity != null) {
                    in = entity.getContent();
                    out = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)new String(out.toByteArray()));
                    }
                }
                if ((sl = response.getStatusLine()).getStatusCode() != 200) {
                    CouchError err = null;
                    if (out != null) {
                        LOGGER.info((Object)("Body content: '" + new String(out.toByteArray()) + "'"));
                        err = this.serializer.toError(new ByteArrayInputStream(out.toByteArray()), "UTF-8");
                    }
                    this.error = new CouchDBException("Error returned from server: '%s'\nError message: %s", sl, err == null ? "-NONE-" : err);
                    break block7;
                }
                Object t = this.serializer.fromJson(new ByteArrayInputStream(out.toByteArray()), "UTF-8", this.type, this.adapters);
                return t;
            }
            finally {
                in.close();
            }
        }
        return null;
    }
}

