/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.couch.db.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.commonjava.couch.util.UrlUtils;

public class ViewRequest {
    public static final String WILDCARD = "%7B%7D";
    public static final String KEY = "key";
    public static final String START_KEY = "startkey";
    public static final String END_KEY = "endkey";
    public static final String INCLUDE_DOCS = "include_docs";
    private final String application;
    private final String view;
    private Set<String> views;
    private final Map<String, String> requestParameters = new LinkedHashMap<String, String>();

    public ViewRequest(String application, String view) {
        this.application = application;
        this.view = view;
    }

    public void setFullRangeForBaseKey(Object baseKey) {
        this.setParameterArray(START_KEY, baseKey);
        this.setParameterArray(END_KEY, baseKey, WILDCARD);
    }

    public void setParameter(String key, Object ... values) {
        if (values.length == 1) {
            this.requestParameters.put(key, UrlUtils.stringQueryParameter(values[0]));
        } else {
            this.setParameterArray(key, values);
        }
    }

    public void setParameterArray(String key, Object ... values) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Object val : values) {
            if (sb.length() > 1) {
                sb.append(",");
            }
            if (WILDCARD.equals(val) || val instanceof Number || val instanceof Boolean) {
                sb.append(val);
                continue;
            }
            sb.append(UrlUtils.stringQueryParameter(val));
        }
        sb.append("]");
        this.requestParameters.put(key, sb.toString());
    }

    public void setParameter(String key, boolean value) {
        this.requestParameters.put(key, Boolean.toString(value));
    }

    public void setParameter(String key, int value) {
        this.requestParameters.put(key, Integer.toString(value));
    }

    public void setParameter(String key, long value) {
        this.requestParameters.put(key, Long.toString(value));
    }

    public String getApplication() {
        return this.application;
    }

    public String getView() {
        return this.view;
    }

    public String toString() {
        return String.format("ViewRequest [application=%s, view=%s, parameters=%s]", this.application, this.view, this.requestParameters);
    }

    public Map<String, String> getRequestParameters() {
        return this.requestParameters;
    }

    public void setViews(Collection<String> views) {
        this.views = new HashSet<String>(views);
    }

    public synchronized void addView(String view) {
        if (this.views == null) {
            this.views = new HashSet<String>();
        }
        this.views.add(view);
    }

    public Set<String> getViews() {
        Set<String> result = this.views;
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }
}

