/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.couch.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.commonjava.couch.db.CouchDBException;
import org.commonjava.couch.db.model.AppDescription;
import org.commonjava.couch.model.CouchApp;
import org.commonjava.couch.model.CouchAppView;

public class CouchAppReader {
    private static final String APP_BASEPATH = "couchapps/";
    private static final String VIEW_SUBPATH = "/views/";
    private static final String MAP_JS = "/map.js";
    private static final String REDUCE_JS = "/reduce.js";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CouchApp readAppDefinition(AppDescription description) throws IOException, CouchDBException {
        ClassLoader cloader = Thread.currentThread().getContextClassLoader();
        String appName = description.getAppName();
        CouchApp app = new CouchApp(appName, description);
        String appBase = APP_BASEPATH + description.getClasspathAppResource();
        String viewBase = appBase + VIEW_SUBPATH;
        Set<String> listing = description.getViewNames();
        if (listing != null) {
            for (String view : listing) {
                String mapPath = viewBase + view + MAP_JS;
                String reducePath = viewBase + view + REDUCE_JS;
                String map = null;
                InputStream in = cloader.getResourceAsStream(mapPath);
                if (in == null) {
                    throw new CouchDBException("Cannot read view: %s in CouchDB application: %s (classpath resource: %s)", view, appName, mapPath);
                }
                StringWriter sWriter = new StringWriter();
                try {
                    List lines = IOUtils.readLines((InputStream)in);
                    for (String line : lines) {
                        String test = line.trim();
                        if (test.startsWith("#") || test.startsWith("/*") || test.startsWith("*") || test.startsWith("//")) continue;
                        sWriter.write(line);
                        sWriter.write(10);
                    }
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                }
                map = sWriter.toString();
                String reduce = null;
                in = cloader.getResourceAsStream(reducePath);
                sWriter = new StringWriter();
                if (in != null) {
                    try {
                        IOUtils.copy((InputStream)in, (Writer)sWriter);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)in);
                    }
                    reduce = sWriter.toString();
                }
                app.addView(view, new CouchAppView(map, reduce));
            }
        }
        return app;
    }
}

