/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.revisions.jaxrs;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.commonjava.indy.bind.jaxrs.IndyResources;
import org.commonjava.indy.bind.jaxrs.util.REST;
import org.commonjava.indy.bind.jaxrs.util.ResponseHelper;
import org.commonjava.indy.model.core.StoreKey;
import org.commonjava.indy.model.core.StoreType;
import org.commonjava.indy.revisions.RevisionsManager;
import org.commonjava.indy.revisions.jaxrs.dto.ChangeSummaryDTO;
import org.commonjava.indy.subsys.git.GitSubsystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/api/revisions/changelog")
@REST
public class ChangelogResource
implements IndyResources {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int DEFAULT_CHANGELOG_COUNT = 10;
    @Inject
    private RevisionsManager revisions;
    @Inject
    private ObjectMapper objectMapper;
    @Inject
    private ResponseHelper responseHelper;

    @ApiOperation(value="Retrieve the changelog for the Indy group/repository definition with the start-index and number of results")
    @ApiResponses(value={@ApiResponse(code=200, message="JSON containing changelog entries", response=ChangeSummaryDTO.class), @ApiResponse(code=400, message="Requested group/repository type is not one of: {remote, hosted, group}")})
    @Path(value="/store/{type}/{name}")
    public Response getStoreChangelog(@ApiParam(allowableValues="hosted,group,remote", required=true) @PathParam(value="type") String t, @PathParam(value="name") String storeName, @QueryParam(value="start") int start, @QueryParam(value="count") int count) {
        Response response;
        StoreType storeType = StoreType.get((String)t);
        if (storeType == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Invalid store type: '" + t + "'")).build();
        }
        StoreKey key = new StoreKey(storeType, storeName);
        if (start < 0) {
            start = 0;
        }
        if (count < 1) {
            count = 10;
        }
        try {
            List dataChangeLog = this.revisions.getDataChangeLog(key, start, count);
            response = this.responseHelper.formatOkResponseWithJsonEntity((Object)new ChangeSummaryDTO(dataChangeLog));
            this.logger.info("\n\n\n\n\n\n{} Sent changelog for: {}\n\n{}\n\n\n\n\n\n\n", new Object[]{new Date(), key, dataChangeLog});
        }
        catch (GitSubsystemException e) {
            String message = String.format("Failed to lookup changelog for: %s. Reason: %s", key, e.getMessage());
            this.logger.error(message, (Throwable)e);
            response = this.responseHelper.formatResponse((Throwable)e);
        }
        return response;
    }
}

