/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.revisions.jaxrs;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.commonjava.indy.bind.jaxrs.IndyResources;
import org.commonjava.indy.bind.jaxrs.util.REST;
import org.commonjava.indy.bind.jaxrs.util.ResponseHelper;
import org.commonjava.indy.revisions.RevisionsManager;
import org.commonjava.indy.revisions.conf.RevisionsConfig;
import org.commonjava.indy.revisions.jaxrs.dto.ChangeSummaryDTO;
import org.commonjava.indy.subsys.git.GitSubsystemException;
import org.commonjava.indy.util.ApplicationStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Data-Directory Revisions")
@Path(value="/api/admin/revisions")
@ApplicationScoped
@REST
public class RevisionsAdminResource
implements IndyResources {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private RevisionsManager revisionsManager;
    @Inject
    private RevisionsConfig config;
    @Inject
    private ObjectMapper objectMapper;
    @Inject
    private ResponseHelper responseHelper;

    @ApiOperation(value="Pull from the configured remote Git repository, updating the Indy data directory with files (merged according to configuration in the [revisions] section)")
    @ApiResponses(value={@ApiResponse(code=200, message="Pull complete"), @ApiResponse(code=400, message="In case the revisions add-on is disabled")})
    @Path(value="/data/pull")
    @GET
    public Response pullDataGitUpdates() {
        Response response;
        if (!this.config.isEnabled()) {
            return this.responseHelper.formatResponse(ApplicationStatus.BAD_REQUEST, "Revisions add-on is disabled");
        }
        try {
            this.revisionsManager.pullDataUpdates();
            response = Response.ok().build();
        }
        catch (GitSubsystemException e) {
            this.logger.error("Failed to pull git updates for data dir: " + e.getMessage(), (Throwable)e);
            response = this.responseHelper.formatResponse((Throwable)e, "Failed to pull git updates for data dir: " + e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="Push Indy data directory content to the configured remote Git repository (if configured in the [revisions] section)")
    @ApiResponses(value={@ApiResponse(code=200, message="Push complete, or not configured"), @ApiResponse(code=400, message="In case the revisions add-on is disabled")})
    @Path(value="/data/push")
    @GET
    public Response pushDataGitUpdates() {
        Response response;
        if (!this.config.isEnabled()) {
            return this.responseHelper.formatResponse(ApplicationStatus.BAD_REQUEST, "Revisions add-on is disabled");
        }
        try {
            this.revisionsManager.pushDataUpdates();
            response = Response.ok().build();
        }
        catch (GitSubsystemException e) {
            this.logger.error("Failed to push git updates for data dir: " + e.getMessage(), (Throwable)e);
            response = this.responseHelper.formatResponse((Throwable)e, "Failed to push git updates for data dir: " + e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="Retrieve the changelog for the Indy data directory content with the specified path, start-index, and number of results")
    @ApiResponses(value={@ApiResponse(code=200, message="JSON containing changelog entries", response=ChangeSummaryDTO.class), @ApiResponse(code=400, message="In case the revisions add-on is disabled")})
    @Path(value="/data/changelog/{path: .+}")
    @GET
    @Produces(value={"application/json"})
    public Response doGet(@PathParam(value="path") String path, @QueryParam(value="start") int start, @QueryParam(value="count") int count) {
        Response response;
        if (!this.config.isEnabled()) {
            return this.responseHelper.formatResponse(ApplicationStatus.BAD_REQUEST, "Revisions add-on is disabled");
        }
        try {
            List listing = this.revisionsManager.getDataChangeLog(path, start, count);
            response = this.responseHelper.formatOkResponseWithJsonEntity((Object)new ChangeSummaryDTO(listing));
        }
        catch (GitSubsystemException e) {
            this.logger.error("Failed to read git changelog from data dir: " + e.getMessage(), (Throwable)e);
            response = this.responseHelper.formatResponse((Throwable)e, "Failed to read git changelog from data dir.");
        }
        return response;
    }
}

