/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.subsys.datafile;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.commonjava.indy.audit.ChangeSummary;
import org.commonjava.indy.subsys.datafile.change.DataFileEventManager;

public final class DataFile {
    private final File file;
    private final DataFileEventManager events;

    DataFile(File file, DataFileEventManager events) {
        this.file = file;
        this.events = events;
    }

    public String[] list() {
        return this.file.list();
    }

    public DataFile getChild(String named) {
        return new DataFile(new File(this.file, named), this.events);
    }

    public String readString() throws IOException {
        String content = FileUtils.readFileToString((File)this.file);
        this.events.accessed(this.file);
        return content;
    }

    public void delete(ChangeSummary summary) throws IOException {
        if (this.file.exists()) {
            FileUtils.forceDelete((File)this.file);
            this.events.deleted(this.file, summary);
        }
    }

    public DataFile getParent() {
        File parent = this.file.getParentFile();
        return parent == null ? null : new DataFile(parent, this.events);
    }

    public boolean mkdirs() {
        if (this.file.isDirectory()) {
            return true;
        }
        return this.file.mkdirs();
    }

    public boolean exists() {
        return this.file.exists();
    }

    public void writeString(String content, ChangeSummary summary) throws IOException {
        FileUtils.write((File)this.file, (CharSequence)content);
        this.events.modified(this.file, summary);
    }

    public void writeString(String content, String encoding, ChangeSummary summary) throws IOException {
        FileUtils.write((File)this.file, (CharSequence)content, (String)encoding);
        this.events.modified(this.file, summary);
    }

    public void writeLines(List<String> lines, String encoding, ChangeSummary summary) throws IOException {
        FileUtils.writeLines((File)this.file, lines, (String)encoding);
        this.events.modified(this.file, summary);
    }

    public void writeLines(List<String> lines, ChangeSummary summary) throws IOException {
        FileUtils.writeLines((File)this.file, lines);
        this.events.modified(this.file, summary);
    }

    public void appendString(String content, ChangeSummary summary) throws IOException {
        FileUtils.write((File)this.file, (CharSequence)content, (boolean)true);
        this.events.modified(this.file, summary);
    }

    public void appendString(String content, String encoding, ChangeSummary summary) throws IOException {
        FileUtils.write((File)this.file, (CharSequence)content, (String)encoding, (boolean)true);
        this.events.modified(this.file, summary);
    }

    public void appendLines(List<String> lines, String encoding, ChangeSummary summary) throws IOException {
        FileUtils.writeLines((File)this.file, lines, (String)encoding, (boolean)true);
        this.events.modified(this.file, summary);
    }

    public void appendLines(List<String> lines, ChangeSummary summary) throws IOException {
        FileUtils.writeLines((File)this.file, lines, (boolean)true);
        this.events.modified(this.file, summary);
    }

    public String toString() {
        return this.file.getPath();
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public void renameTo(DataFile target, ChangeSummary summary) {
        this.file.renameTo(target.file);
        this.events.modified(this.file, summary);
        this.events.modified(target.file, summary);
    }

    public List<String> readLines() throws IOException {
        List lines = FileUtils.readLines((File)this.file);
        this.events.accessed(this.file);
        return lines;
    }

    public String getPath() {
        return this.file.getPath();
    }

    public void touch() {
        this.events.accessed(this.file);
    }

    public DataFile[] listFiles(FileFilter fileFilter) {
        File[] files = this.file.listFiles(fileFilter);
        if (files == null) {
            return null;
        }
        DataFile[] ffiles = new DataFile[files.length];
        for (int i = 0; i < files.length; ++i) {
            ffiles[i] = new DataFile(files[i], this.events);
        }
        return ffiles;
    }

    public String getName() {
        return this.file.getName();
    }

    public File getDetachedFile() {
        return this.file;
    }
}

