/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.subsys.datafile;

import java.io.File;
import java.nio.file.Paths;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.commonjava.indy.subsys.datafile.DataFile;
import org.commonjava.indy.subsys.datafile.change.DataFileEventManager;
import org.commonjava.indy.subsys.datafile.conf.DataFileConfiguration;

@ApplicationScoped
public class DataFileManager {
    @Inject
    private DataFileConfiguration config;
    @Inject
    private DataFileEventManager fileEventManager;

    protected DataFileManager() {
    }

    public DataFileManager(File rootDir, DataFileEventManager fileEventManager) {
        this.fileEventManager = fileEventManager;
        this.config = new DataFileConfiguration(rootDir);
    }

    public DataFileManager(DataFileConfiguration config, DataFileEventManager fileEventManager) {
        this.config = config;
        this.fileEventManager = fileEventManager;
    }

    public DataFile getDataFile(String ... pathParts) {
        File base = this.config.getDataBasedir();
        File f = Paths.get(base.getAbsolutePath(), pathParts).toFile();
        return new DataFile(f, this.fileEventManager);
    }

    public File getDetachedDataBasedir() {
        return this.config.getDataBasedir();
    }

    public File getDetachedWorkBasedir() {
        return this.config.getWorkBasedir();
    }
}

