/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.subsys.datafile.change;

import java.io.File;
import java.util.Date;
import org.commonjava.indy.audit.ChangeSummary;
import org.commonjava.indy.subsys.datafile.change.DataFileEventType;

public final class DataFileEvent
implements Comparable<DataFileEvent> {
    private static long COUNTER = 0L;
    private final long id = COUNTER++;
    private final Date timestamp = new Date();
    private final File file;
    private final ChangeSummary summary;
    private final DataFileEventType type;

    DataFileEvent(File file, DataFileEventType type, ChangeSummary summary) {
        this.file = file;
        this.type = type;
        this.summary = summary;
    }

    DataFileEvent(File file) {
        this.file = file;
        this.type = DataFileEventType.accessed;
        this.summary = null;
    }

    public String toString() {
        String summ = this.summary == null ? "" : "\nSummary: " + this.summary;
        return String.format("DataFileEvent [id=%s, file=%s, type=%s, timestamp=%s]%s", new Object[]{this.id, this.file, this.type, this.timestamp, summ});
    }

    public File getFile() {
        return this.file;
    }

    public ChangeSummary getSummary() {
        return this.summary;
    }

    public DataFileEventType getType() {
        return this.type;
    }

    public long getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataFileEvent other = (DataFileEvent)obj;
        return this.id == other.id;
    }

    @Override
    public int compareTo(DataFileEvent other) {
        return Long.valueOf(this.id).compareTo(other.id);
    }

    public Date getTimestamp() {
        return this.timestamp;
    }
}

