/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.subsys.datafile.change;

import java.io.File;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.commonjava.indy.audit.ChangeSummary;
import org.commonjava.indy.subsys.datafile.change.DataFileEvent;
import org.commonjava.indy.subsys.datafile.change.DataFileEventType;

@ApplicationScoped
public class DataFileEventManager {
    @Inject
    private Event<DataFileEvent> events;

    public void fire(DataFileEvent evt) {
        if (this.events != null) {
            this.events.fire((Object)evt);
        }
    }

    public void accessed(File file) {
        this.fire(new DataFileEvent(file));
    }

    public void modified(File file, ChangeSummary summary) {
        this.fire(new DataFileEvent(file, DataFileEventType.modified, summary));
    }

    public void deleted(File file, ChangeSummary summary) {
        this.fire(new DataFileEvent(file, DataFileEventType.deleted, summary));
    }
}

