/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.indy.subsys.datafile.conf;

import java.io.File;
import java.io.InputStream;
import java.util.Properties;
import javax.enterprise.context.ApplicationScoped;
import org.commonjava.indy.conf.IndyConfigInfo;
import org.commonjava.indy.conf.SystemPropertyProvider;
import org.commonjava.web.config.annotation.ConfigName;
import org.commonjava.web.config.annotation.SectionName;

@SectionName(value="flatfiles")
@ApplicationScoped
public class DataFileConfiguration
implements IndyConfigInfo,
SystemPropertyProvider {
    public static final String SECTION_NAME = "flatfiles";
    private static final String INDY_WORK_BASEDIR = "indy.work";
    private static final String INDY_DATA_BASEDIR = "indy.data";
    public static final String DEFAULT_ROOT_DIR = "/var/lib/indy";
    public static final String DEFAULT_DATA_SUBDIR = "data";
    public static final String DEFAULT_WORK_SUBDIR = "work";
    public static final File DEFAULT_DATA_BASEDIR = new File(System.getProperty("indy.home", "/var/lib/indy"), "data");
    private static final File DEFAULT_WORK_BASEDIR = new File(System.getProperty("indy.home", "/var/lib/indy"), "work");
    private File dataBasedir;
    private File workBasedir;

    public Properties getSystemProperties() {
        Properties properties = new Properties();
        properties.setProperty(INDY_DATA_BASEDIR, this.getDataBasedir().getAbsolutePath());
        properties.setProperty(INDY_WORK_BASEDIR, this.getWorkBasedir().getAbsolutePath());
        return properties;
    }

    public DataFileConfiguration() {
    }

    public DataFileConfiguration(File rootDir) {
        this.dataBasedir = new File(rootDir, DEFAULT_DATA_SUBDIR);
        this.workBasedir = new File(rootDir, DEFAULT_WORK_SUBDIR);
    }

    public DataFileConfiguration(File dataDir, File workDir) {
        this.dataBasedir = dataDir;
        this.workBasedir = workDir;
    }

    public File getDataBasedir() {
        return this.dataBasedir == null ? DEFAULT_DATA_BASEDIR : this.dataBasedir;
    }

    @ConfigName(value="data.dir")
    public void setDataBasedir(File dataBasedir) {
        this.dataBasedir = dataBasedir;
    }

    public DataFileConfiguration withDataBasedir(File dataBasedir) {
        this.dataBasedir = dataBasedir;
        return this;
    }

    public File getDataDir(String name) {
        File d = new File(this.getDataBasedir(), name);
        d.mkdirs();
        return d;
    }

    public File getWorkBasedir() {
        return this.workBasedir == null ? DEFAULT_WORK_BASEDIR : this.workBasedir;
    }

    @ConfigName(value="work.dir")
    public void setWorkBasedir(File workBasedir) {
        this.workBasedir = workBasedir;
    }

    public DataFileConfiguration withWorkBasedir(File workBasedir) {
        this.workBasedir = workBasedir;
        return this;
    }

    public String getDefaultConfigFileName() {
        return "main.conf";
    }

    public InputStream getDefaultConfig() {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream("default-flatfiles.conf");
    }
}

