/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.common.model;

import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Dependency;
import org.commonjava.maven.atlas.ident.ref.InvalidRefException;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleArtifactRef;
import org.commonjava.maven.atlas.ident.ref.TypeAndClassifier;

public class SimpleScopedArtifactRef
extends SimpleArtifactRef {
    private final String scope;

    public SimpleScopedArtifactRef(String group, String artifact, String version, String type, String classifier, String scope) {
        super(group, artifact, version, type, classifier);
        this.scope = scope;
    }

    public SimpleScopedArtifactRef(ProjectVersionRef ref, TypeAndClassifier tc, String scope) {
        super(ref, tc);
        this.scope = scope;
    }

    public SimpleScopedArtifactRef(Dependency dependency) {
        super(dependency.getGroupId(), dependency.getArtifactId(), StringUtils.isEmpty(dependency.getVersion()) ? "*" : dependency.getVersion(), dependency.getType(), dependency.getClassifier());
        this.scope = dependency.getScope();
    }

    public static SimpleScopedArtifactRef parse(String spec) {
        return SimpleScopedArtifactRef.parse(spec, null);
    }

    public static SimpleScopedArtifactRef parse(String spec, String scope) {
        String[] parts = spec.split(":");
        if (parts.length < 3 || StringUtils.isEmpty(parts[0]) || StringUtils.isEmpty(parts[1]) || StringUtils.isEmpty(parts[2])) {
            throw new InvalidRefException("SimpleArtifactRef must contain AT LEAST non-empty groupId, artifactId, AND version. (Given: '" + spec + "')", new Object[0]);
        }
        String g = parts[0];
        String a = parts[1];
        String v = parts[2];
        String t = "pom";
        String c = null;
        if (parts.length > 3) {
            t = v;
            v = parts[3];
            if (parts.length > 4) {
                c = parts[4];
            }
        }
        return new SimpleScopedArtifactRef(g, a, v, t, c, scope);
    }

    @Override
    public String toString() {
        if (StringUtils.isNotEmpty(this.scope)) {
            return super.toString() + " : scope=" + this.scope;
        }
        return super.toString();
    }

    public String getScope() {
        return this.scope;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleScopedArtifactRef)) {
            return false;
        }
        SimpleScopedArtifactRef other = (SimpleScopedArtifactRef)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        return !(this$scope == null ? other$scope != null : !this$scope.equals(other$scope));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleScopedArtifactRef;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        return result;
    }
}

