/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.common.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.commonjava.maven.ext.common.session.MavenSessionHandler;

public final class ProfileUtils {
    public static final String PROFILE_SCANNING = "scanActiveProfiles";
    public static String PROFILE_SCANNING_DEFAULT = "true";

    public static List<Profile> getProfiles(MavenSessionHandler session, Model model) {
        ArrayList<Profile> result = new ArrayList<Profile>();
        List<Profile> profiles = model.getProfiles();
        boolean scanActiveProfiles = Boolean.parseBoolean(session.getUserProperties().getProperty(PROFILE_SCANNING, PROFILE_SCANNING_DEFAULT));
        if (profiles != null) {
            if (scanActiveProfiles) {
                for (Profile p : profiles) {
                    if (!session.getActiveProfiles().contains(p.getId())) continue;
                    result.add(p);
                }
            } else {
                result.addAll(profiles);
            }
        }
        return result;
    }

    private ProfileUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

