/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Profile;
import org.apache.maven.profiles.DefaultProfileManager;
import org.apache.maven.profiles.activation.ProfileActivationException;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.json.PME;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.util.JSONUtils;
import org.commonjava.maven.ext.common.util.ProfileUtils;
import org.commonjava.maven.ext.common.util.ProjectComparator;
import org.commonjava.maven.ext.common.util.WildcardMap;
import org.commonjava.maven.ext.core.ConfigList;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.impl.Manipulator;
import org.commonjava.maven.ext.core.impl.PreparseGroovyManipulator;
import org.commonjava.maven.ext.core.state.CommonState;
import org.commonjava.maven.ext.core.state.DependencyState;
import org.commonjava.maven.ext.core.state.RelocationState;
import org.commonjava.maven.ext.core.util.ManipulatorPriorityComparator;
import org.commonjava.maven.ext.io.PomIO;
import org.commonjava.maven.ext.io.resolver.ExtensionInfrastructure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class ManipulationManager {
    private static final String MARKER_PATH = "target";
    public static final String MARKER_FILE = "target" + File.separatorChar + "pom-manip-ext-marker.txt";
    public static final String REPORT_JSON_DEFAULT = "alignmentReport.json";
    public static final String REPORT_TXT_OUTPUT_FILE = "reportTxtOutputFile";
    public static final String REPORT_JSON_OUTPUT_FILE = "reportJSONOutputFile";
    public static final String DEPRECATED_PROPERTIES = "enabledDeprecatedProperties";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Manipulator> manipulators;
    private final Map<String, ExtensionInfrastructure> infrastructure;
    private final PomIO pomIO;
    private final PreparseGroovyManipulator preparseGroovyManipulator;
    private final PME jsonReport = new PME();
    private List<Manipulator> orderedManipulators;

    @Inject
    public ManipulationManager(Map<String, Manipulator> manipulators, Map<String, ExtensionInfrastructure> infrastructure, PomIO pomIO, PreparseGroovyManipulator preparseGroovyManipulator) {
        this.manipulators = manipulators;
        this.infrastructure = infrastructure;
        this.pomIO = pomIO;
        this.preparseGroovyManipulator = preparseGroovyManipulator;
    }

    public void init(ManipulationSession session) throws ManipulationException {
        this.logger.debug("Initialising ManipulationManager with user properties {}", (Object)session.getUserProperties());
        boolean deprecatedDisabled = !Boolean.parseBoolean(session.getUserProperties().getProperty(DEPRECATED_PROPERTIES, "false"));
        HashMap<String, String> deprecatedUsage = new HashMap<String, String>();
        session.getUserProperties().stringPropertyNames().forEach(p -> {
            if (!p.equals("maven.repo.local")) {
                if (ConfigList.allConfigValues.keySet().stream().noneMatch(p::startsWith)) {
                    this.logger.warn("Unknown configuration value {}", p);
                }
            }
            this.logger.debug("Examining for deprecated properties for {}", p);
            ConfigList.allConfigValues.entrySet().stream().filter(e -> p.startsWith((String)e.getKey())).filter(Map.Entry::getValue).forEach(up -> deprecatedUsage.put((String)p, (String)up.getKey()));
        });
        if (deprecatedUsage.size() > 0) {
            deprecatedUsage.forEach((k, v) -> this.logger.warn("Located deprecated property {} in user properties (with matcher of {})", k, v));
            if (deprecatedDisabled) {
                throw new ManipulationException("Deprecated properties are being used. Either remove them or set enabledDeprecatedProperties=true", new Object[0]);
            }
        }
        for (ExtensionInfrastructure infra : this.infrastructure.values()) {
            infra.init();
        }
        this.orderedManipulators = new ArrayList<Manipulator>(this.manipulators.values());
        this.orderedManipulators.sort(Collections.reverseOrder(new ManipulatorPriorityComparator()));
        for (Manipulator manipulator : this.orderedManipulators) {
            this.logger.debug("Initialising manipulator " + manipulator.getClass().getSimpleName());
            manipulator.init(session);
        }
        this.orderedManipulators.sort(new ManipulatorPriorityComparator());
        CommonState cState = new CommonState(session.getUserProperties());
        DependencyState dState = session.getState(DependencyState.class);
        if (!dState.getDependencyOverrides().isEmpty() && cState.getStrictDependencyPluginPropertyValidation() != 0) {
            this.logger.warn("Disabling strictPropertyValidation as dependencyOverrides are enabled");
            cState.setStrictDependencyPluginPropertyValidation(0);
        }
        session.setState(cState);
    }

    public void scanAndApply(ManipulationSession session) throws ManipulationException {
        this.preparseGroovyManipulator.applyChanges(session);
        if (!session.getPom().exists()) {
            throw new ManipulationException("Manipulation engine disabled. Project {} cannot be found.", session.getPom());
        }
        List<Project> currentProjects = this.pomIO.parseProject(session.getPom());
        ArrayList<Project> originalProjects = new ArrayList<Project>();
        currentProjects.forEach(p -> originalProjects.add(new Project((Project)p)));
        Project originalExecutionRoot = (Project)originalProjects.get(0);
        if (!originalExecutionRoot.isExecutionRoot()) {
            throw new ManipulationException("First project is not execution root : {}", originalProjects);
        }
        session.getActiveProfiles().addAll(this.parseActiveProfiles(session, currentProjects));
        session.setProjects(currentProjects);
        Set<Project> changed = this.applyManipulations(currentProjects);
        if (!changed.isEmpty()) {
            this.logger.info("Maven-Manipulation-Extension: Rewrite changed: {}", (Object)currentProjects);
            ProjectVersionRef executionRoot = this.pomIO.rewritePOMs(changed);
            this.jsonReport.getGav().setPVR(executionRoot);
            this.jsonReport.getGav().setOriginalGAV(originalExecutionRoot.getKey().toString());
            try {
                session.getTargetDir().mkdir();
                new File(session.getTargetDir().getParentFile(), MARKER_FILE).createNewFile();
                WildcardMap<ProjectVersionRef> map = session.getState(RelocationState.class) == null ? new WildcardMap<ProjectVersionRef>() : session.getState(RelocationState.class).getDependencyRelocations();
                String report = ProjectComparator.compareProjects(session, this.jsonReport, map, originalProjects, currentProjects);
                this.logger.info("{}{}", (Object)System.lineSeparator(), (Object)report);
                String reportTxtOutputFile = session.getUserProperties().getProperty(REPORT_TXT_OUTPUT_FILE, "");
                if (StringUtils.isNotEmpty(reportTxtOutputFile)) {
                    File reportFile = new File(reportTxtOutputFile);
                    FileUtils.writeStringToFile(reportFile, report, StandardCharsets.UTF_8);
                }
                String reportJsonOutputFile = session.getUserProperties().getProperty(REPORT_JSON_OUTPUT_FILE, session.getTargetDir() + File.separator + REPORT_JSON_DEFAULT);
                try (FileWriter writer = new FileWriter(new File(reportJsonOutputFile));){
                    writer.write(JSONUtils.jsonToString(this.jsonReport));
                }
            }
            catch (IOException e) {
                this.logger.error("Unable to create marker or result file", e);
                throw new ManipulationException("Marker/result file creation failed", e);
            }
        }
        for (ExtensionInfrastructure e : this.infrastructure.values()) {
            e.finish();
        }
        this.logger.info("Maven-Manipulation-Extension: Finished.");
    }

    private Set<String> parseActiveProfiles(ManipulationSession session, List<Project> projects) throws ManipulationException {
        HashSet<String> activeProfiles = new HashSet<String>();
        DefaultProfileManager dpm = new DefaultProfileManager(session.getSession().getContainer(), session.getUserProperties());
        this.logger.debug("Explicitly activating {}", (Object)session.getActiveProfiles());
        dpm.explicitlyActivate(session.getActiveProfiles());
        for (Project p : projects) {
            p.getModel().getProfiles().stream().filter(newProfile -> !dpm.getProfilesById().containsKey(newProfile.getId())).forEach(newProfile -> dpm.addProfile(newProfile.clone()));
            try {
                List ap = dpm.getActiveProfiles();
                activeProfiles.addAll(ap.stream().map(Profile::getId).collect(Collectors.toList()));
            }
            catch (ProfileActivationException e) {
                throw new ManipulationException("Activation detection failure", e);
            }
        }
        if (this.logger.isDebugEnabled()) {
            String profileScanningProp = session.getUserProperties().getProperty("scanActiveProfiles", ProfileUtils.PROFILE_SCANNING_DEFAULT);
            boolean profileScanning = Boolean.parseBoolean(profileScanningProp);
            this.logger.debug("Will {}scan all profiles and returning active profiles of {}", (Object)(profileScanning ? "not " : ""), (Object)activeProfiles);
        }
        return activeProfiles;
    }

    private Set<Project> applyManipulations(List<Project> projects) throws ManipulationException {
        HashSet<Project> changed = new HashSet<Project>();
        for (Manipulator manipulator : this.orderedManipulators) {
            this.logger.info("Running manipulator {}", (Object)manipulator.getClass().getName());
            Set<Project> mChanged = manipulator.applyChanges(projects);
            if (mChanged == null) continue;
            changed.addAll(mChanged);
        }
        if (changed.isEmpty()) {
            this.logger.info("Maven-Manipulation-Extension: No changes.");
        }
        return changed;
    }

    public List<Manipulator> getOrderedManipulators() {
        return this.orderedManipulators;
    }
}

