/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.impl.Manipulator;
import org.commonjava.maven.ext.core.state.DependencyInjectionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="dependency-injection-manipulator")
@Singleton
public class DependencyInjectionManipulator
implements Manipulator {
    private static final String UNUSED_DECLARED = "ignoredUnusedDeclaredDependencies";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ManipulationSession session;

    @Override
    public void init(ManipulationSession session) {
        session.setState(new DependencyInjectionState(session.getUserProperties()));
        this.session = session;
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects) throws ManipulationException {
        DependencyInjectionState state = this.session.getState(DependencyInjectionState.class);
        if (!this.session.isEnabled() || !state.isEnabled()) {
            this.logger.debug("{}: Nothing to do!", (Object)this.getClass().getSimpleName());
            return Collections.emptySet();
        }
        HashSet<Project> changed = new HashSet<Project>();
        projects.stream().filter(Project::isInheritanceRoot).forEach(project -> {
            Optional<Plugin> mdpPlugin;
            this.logger.info("Applying injection changes to {}", project);
            DependencyManagement dependencyManagement = project.getModel().getDependencyManagement();
            if (dependencyManagement == null) {
                dependencyManagement = new DependencyManagement();
                project.getModel().setDependencyManagement(dependencyManagement);
                this.logger.debug("Added <DependencyManagement/> for current project");
            }
            dependencyManagement.getDependencies().addAll(0, this.getDependencies(state.getDependencyInjection()));
            if (state.isAddIgnoreUnusedAnalzyePlugin() && (mdpPlugin = project.getModel().getBuild().getPlugins().stream().filter(p -> p.getArtifactId().equals("maven-dependency-plugin")).findFirst()).isPresent()) {
                this.logger.info("Found plugin {} to add ignoredUnusedDeclaredDependency for {}", (Object)mdpPlugin, (Object)state.getDependencyInjection());
                PluginExecution execution = mdpPlugin.get().getExecutionsAsMap().get("analyze");
                if (execution != null) {
                    Xpp3Dom originalConfiguration = (Xpp3Dom)execution.getConfiguration();
                    for (ProjectVersionRef pvr : state.getDependencyInjection()) {
                        Xpp3Dom ignoredUnusedDeclaredDeps;
                        Xpp3Dom ignoreToAdd = new Xpp3Dom("ignoredUnusedDeclaredDependency");
                        ignoreToAdd.setValue(pvr.getGroupId() + ":" + pvr.getArtifactId());
                        if (originalConfiguration == null) {
                            originalConfiguration = new Xpp3Dom("configuration");
                            execution.setConfiguration(originalConfiguration);
                        }
                        if (originalConfiguration.getChild(UNUSED_DECLARED) == null) {
                            ignoredUnusedDeclaredDeps = new Xpp3Dom(UNUSED_DECLARED);
                            originalConfiguration.addChild(ignoredUnusedDeclaredDeps);
                        } else {
                            ignoredUnusedDeclaredDeps = originalConfiguration.getChild(UNUSED_DECLARED);
                        }
                        ignoredUnusedDeclaredDeps.addChild(ignoreToAdd);
                    }
                    this.logger.debug("ignoreUnusedDeclaredDependencies is now {}", (Object)originalConfiguration.getChild(UNUSED_DECLARED));
                }
            }
            changed.add((Project)project);
        });
        return changed;
    }

    private List<Dependency> getDependencies(List<ProjectVersionRef> pvr) {
        ArrayList<Dependency> results = new ArrayList<Dependency>();
        for (ProjectVersionRef p : pvr) {
            Dependency d = new Dependency();
            d.setGroupId(p.getGroupId());
            d.setArtifactId(p.getArtifactId());
            d.setVersion(p.getVersionString());
            results.add(d);
        }
        return results;
    }

    @Override
    public int getExecutionIndex() {
        return 8;
    }
}

