/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.InputLocationTracker;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.InvalidRefException;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.model.SimpleScopedArtifactRef;
import org.commonjava.maven.ext.common.util.PropertyResolver;
import org.commonjava.maven.ext.common.util.WildcardMap;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.impl.CommonManipulator;
import org.commonjava.maven.ext.core.impl.Manipulator;
import org.commonjava.maven.ext.core.state.CommonState;
import org.commonjava.maven.ext.core.state.DependencyState;
import org.commonjava.maven.ext.core.state.RESTState;
import org.commonjava.maven.ext.core.util.DependencyPluginUtils;
import org.commonjava.maven.ext.core.util.DependencyPluginWrapper;
import org.commonjava.maven.ext.core.util.IdUtils;
import org.commonjava.maven.ext.core.util.PluginReference;
import org.commonjava.maven.ext.core.util.PropertiesUtils;
import org.commonjava.maven.ext.core.util.PropertyMapper;
import org.commonjava.maven.ext.io.ModelIO;
import org.commonjava.maven.ext.io.resolver.GalleyAPIWrapper;

@Named(value="project-dependency-manipulator")
@Singleton
public class DependencyManipulator
extends CommonManipulator
implements Manipulator {
    private final GalleyAPIWrapper galleyWrapper;
    private final Map<Project, Map<String, PropertyMapper>> versionPropertyUpdateMap = new LinkedHashMap<Project, Map<String, PropertyMapper>>();

    @Inject
    public DependencyManipulator(ModelIO effectiveModelBuilder, GalleyAPIWrapper galleyWrapper) {
        this.effectiveModelBuilder = effectiveModelBuilder;
        this.galleyWrapper = galleyWrapper;
    }

    @Override
    public void init(ManipulationSession session) throws ManipulationException {
        session.setState(new DependencyState(session.getUserProperties()));
        this.session = session;
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects) throws ManipulationException {
        DependencyState state = this.session.getState(DependencyState.class);
        if (!this.session.isEnabled() || !state.isEnabled()) {
            this.logger.debug("{}: Nothing to do!", (Object)this.getClass().getSimpleName());
            return Collections.emptySet();
        }
        return this.internalApplyChanges(projects, this.loadRemoteOverrides());
    }

    private Map<ArtifactRef, String> loadRemoteOverrides() throws ManipulationException {
        DependencyState depState = this.session.getState(DependencyState.class);
        RESTState restState = this.session.getState(RESTState.class);
        List<ProjectVersionRef> gavs = depState.getRemoteBOMDepMgmt();
        Map<String, ProjectVersionRef> extraGAVs = depState.getExtraBOMs();
        Map<String, Map<ProjectRef, String>> extraBOMOverrides = depState.getExtraBOMDepMgmts();
        Map<ArtifactRef, String> restOverrides = depState.getRemoteRESTOverrides();
        LinkedHashMap<ArtifactRef, String> bomOverrides = new LinkedHashMap<ArtifactRef, String>();
        Map<Object, Object> mergedOverrides = new LinkedHashMap();
        this.logger.info("Remote precedence is {}", (Object)depState.getPrecedence());
        if (gavs != null) {
            Iterator<Map.Entry<String, ProjectVersionRef>> iter = gavs.listIterator(gavs.size());
            while (iter.hasPrevious()) {
                ProjectVersionRef ref = (ProjectVersionRef)iter.previous();
                Map<ArtifactRef, String> rBom = this.effectiveModelBuilder.getRemoteDependencyVersionOverrides(ref);
                bomOverrides.putAll(rBom);
            }
        }
        for (Map.Entry<String, ProjectVersionRef> entry : extraGAVs.entrySet()) {
            extraBOMOverrides.put(entry.getKey(), this.effectiveModelBuilder.getRemoteDependencyVersionOverridesByProject(entry.getValue()));
        }
        if (depState.getPrecedence() == DependencyState.DependencyPrecedence.BOM) {
            mergedOverrides = bomOverrides;
            if (mergedOverrides.isEmpty()) {
                String msg = restState.isEnabled() ? "dependencySource for restURL" : "dependencyManagement";
                this.logger.warn("No dependencies found for dependencySource {}. Has {} been configured? ", (Object)depState.getPrecedence(), (Object)msg);
            }
        } else if (depState.getPrecedence() == DependencyState.DependencyPrecedence.REST) {
            mergedOverrides = restOverrides;
            if (mergedOverrides.isEmpty()) {
                this.logger.warn("No dependencies found for dependencySource {}. Has restURL been configured? ", (Object)depState.getPrecedence());
            }
        } else if (depState.getPrecedence() == DependencyState.DependencyPrecedence.RESTBOM) {
            mergedOverrides = bomOverrides;
            this.removeDuplicateArtifacts(mergedOverrides, restOverrides);
            mergedOverrides.putAll(restOverrides);
        } else if (depState.getPrecedence() == DependencyState.DependencyPrecedence.BOMREST) {
            mergedOverrides = restOverrides;
            this.removeDuplicateArtifacts(mergedOverrides, bomOverrides);
            mergedOverrides.putAll(bomOverrides);
        }
        this.logger.debug("Final remote override list is {}", (Object)mergedOverrides);
        return mergedOverrides;
    }

    private void removeDuplicateArtifacts(Map<ArtifactRef, String> mergedOverrides, Map<ArtifactRef, String> targetOverrides) {
        Iterator<Map.Entry<ArtifactRef, String>> it = mergedOverrides.entrySet().iterator();
        block0: while (it.hasNext()) {
            Map.Entry<ArtifactRef, String> mergedOverridesEntry = it.next();
            ArtifactRef key = mergedOverridesEntry.getKey();
            ProjectRef pRef = key.asProjectRef();
            for (Map.Entry<ArtifactRef, String> tatgetOverridesEntry : targetOverrides.entrySet()) {
                ArtifactRef target = tatgetOverridesEntry.getKey();
                if (!pRef.equals(target.asProjectRef())) continue;
                this.logger.debug("Merging sources ; entry {}={} clashes (and will be removed) with precedence given to {}={}", key, mergedOverridesEntry.getValue(), target, tatgetOverridesEntry.getValue());
                it.remove();
                continue block0;
            }
        }
    }

    @Override
    public int getExecutionIndex() {
        return 40;
    }

    private Set<Project> internalApplyChanges(List<Project> projects, Map<ArtifactRef, String> overrides) throws ManipulationException {
        DependencyState state = this.session.getState(DependencyState.class);
        CommonState cState = this.session.getState(CommonState.class);
        HashSet<Project> result = new HashSet<Project>(projects.size());
        for (Project project : projects) {
            Model model = project.getModel();
            if (overrides.isEmpty() && state.getDependencyOverrides().isEmpty()) continue;
            this.apply(project, model, overrides);
            result.add(project);
        }
        if (!result.isEmpty()) {
            if (cState.getStrictDependencyPluginPropertyValidation() > 0) {
                this.logger.info("Iterating to validate dependency updates...");
                for (Project project : this.versionPropertyUpdateMap.keySet()) {
                    this.validateDependenciesUpdatedProperty(cState, project, project.getResolvedDependencies(this.session));
                    for (Map map : project.getResolvedProfileDependencies(this.session).values()) {
                        this.validateDependenciesUpdatedProperty(cState, project, map);
                    }
                }
            }
            this.logger.info("Iterating for property overrides...{}", (Object)this.versionPropertyUpdateMap);
            for (Map.Entry entry : this.versionPropertyUpdateMap.entrySet()) {
                Project project = (Project)entry.getKey();
                Map map = (Map)entry.getValue();
                this.logger.debug("Checking property override within project {}", (Object)project);
                for (Map.Entry entry2 : map.entrySet()) {
                    PropertyMapper mapper;
                    String newVersion;
                    String key = (String)entry2.getKey();
                    PropertiesUtils.PropertyUpdate found = PropertiesUtils.updateProperties(this.session, project, false, key, newVersion = (mapper = (PropertyMapper)entry2.getValue()).getNewVersion());
                    if (found != PropertiesUtils.PropertyUpdate.NOTFOUND) continue;
                    this.logger.info("Unable to find a property for {} to update", (Object)key);
                    this.logger.info("Adding property {} with {}", (Object)key, (Object)newVersion);
                    project.getInheritedList().get(0).getModel().getProperties().setProperty(key, newVersion);
                }
            }
            this.explicitOverridePropertyUpdates(this.session);
        }
        return result;
    }

    private void apply(Project project, Model model, Map<ArtifactRef, String> overrides) throws ManipulationException {
        WildcardMap<String> explicitOverrides = new WildcardMap<String>();
        String projectGA = IdUtils.ga(project);
        DependencyState dependencyState = this.session.getState(DependencyState.class);
        CommonState commonState = this.session.getState(CommonState.class);
        this.logger.debug("Processing project {}", (Object)projectGA);
        Map<ArtifactRef, String> originalOverrides = new LinkedHashMap<ArtifactRef, String>(overrides);
        originalOverrides = this.removeReactorGAs(originalOverrides);
        this.logger.debug("Using dependencyOverride of {}", (Object)dependencyState.getDependencyOverrides());
        try {
            originalOverrides = this.applyModuleVersionOverrides(projectGA, dependencyState.getDependencyOverrides(), originalOverrides, explicitOverrides, dependencyState.getExtraBOMDepMgmts());
            this.logger.debug("Module overrides are:{}{}", (Object)System.lineSeparator(), (Object)originalOverrides);
            this.logger.debug("Explicit overrides are:{}{}", (Object)System.lineSeparator(), (Object)explicitOverrides);
        }
        catch (InvalidRefException e) {
            this.logger.error("Invalid module exclusion override {} : {}", (Object)originalOverrides, (Object)explicitOverrides);
            throw e;
        }
        if (project.isInheritanceRoot()) {
            if (project.getModelParent() != null) {
                for (Map.Entry<ArtifactRef, String> entry : originalOverrides.entrySet()) {
                    ArtifactRef pvr = entry.getKey();
                    String oldValue = project.getModelParent().getVersion();
                    String string = entry.getValue();
                    if (!pvr.asProjectRef().equals(SimpleProjectRef.parse(IdUtils.ga(project.getModelParent())))) continue;
                    if (commonState.isStrict() && !PropertiesUtils.checkStrictValue(this.session, oldValue, string)) {
                        if (commonState.isFailOnStrictViolation()) {
                            throw new ManipulationException("Parent reference {} replacement: {} of original version: {} violates the strict version-alignment rule!", IdUtils.ga(project.getModelParent()), string, oldValue);
                        }
                        this.logger.warn("Parent reference {}:{} replacement: {} of original version: {} violates the strict version-alignment rule!", project.getModelParent().getGroupId(), project.getModelParent().getArtifactId(), string, oldValue);
                        continue;
                    }
                    this.logger.debug("Modifying parent reference from {} to {} for {}:{}", model.getParent().getVersion(), string, project.getModelParent().getGroupId(), project.getModelParent().getArtifactId());
                    model.getParent().setVersion(string);
                    break;
                }
                Dependency d = new Dependency();
                d.setGroupId(project.getModelParent().getGroupId());
                d.setArtifactId(project.getModelParent().getArtifactId());
                d.setVersion(project.getModelParent().getVersion());
                Map<SimpleScopedArtifactRef, Dependency> pDepMap = Collections.singletonMap(new SimpleScopedArtifactRef(d), d);
                this.applyExplicitOverrides(project, pDepMap, explicitOverrides, this.explicitVersionPropertyUpdateMap);
                project.getModelParent().setVersion(d.getVersion());
            }
            this.logger.debug("Applying overrides to managed dependencies for: {}", (Object)projectGA);
            Map<ArtifactRef, String> nonMatchingVersionOverrides = this.applyOverrides(project, project.getResolvedManagedDependencies(this.session), explicitOverrides, originalOverrides);
            this.applyExplicitOverrides(project, project.getResolvedManagedDependencies(this.session), explicitOverrides, this.explicitVersionPropertyUpdateMap);
            if (commonState.isOverrideTransitive() && dependencyState.getRemoteBOMDepMgmt() != null) {
                Set<ArtifactRef> overrideRefs = overrides.keySet();
                Iterator<Map<ArtifactRef, Dependency>> extraDeps = new ArrayList(overrideRefs.size());
                for (ArtifactRef artifactRef : overrideRefs) {
                    if (!nonMatchingVersionOverrides.containsKey(artifactRef)) continue;
                    Dependency dependency = new Dependency();
                    dependency.setGroupId(artifactRef.getGroupId());
                    dependency.setArtifactId(artifactRef.getArtifactId());
                    dependency.setType(artifactRef.getType());
                    dependency.setClassifier(artifactRef.getClassifier());
                    String artifactVersion = originalOverrides.get(artifactRef);
                    dependency.setVersion(artifactVersion);
                    extraDeps.add((Map<ArtifactRef, Dependency>)((Object)dependency));
                    this.logger.debug("New entry added to <dependencyManagement/> - {} : {}", (Object)artifactRef, (Object)artifactVersion);
                }
                DependencyManagement dependencyManagement = model.getDependencyManagement();
                if (!extraDeps.isEmpty()) {
                    if (dependencyManagement == null) {
                        dependencyManagement = new DependencyManagement();
                        model.setDependencyManagement(dependencyManagement);
                        this.logger.debug("Added <DependencyManagement/> for current project");
                    }
                    dependencyManagement.getDependencies().addAll(0, (Collection<Dependency>)((Object)extraDeps));
                }
            } else if (commonState.isOverrideTransitive() && dependencyState.getRemoteBOMDepMgmt() == null) {
                this.logger.warn("Ignoring {} flag since it was used without the {} option", (Object)"overrideTransitive", (Object)"dependencyManagement");
            } else {
                this.logger.debug("Non-matching dependencies ignored.");
            }
        } else {
            this.logger.debug("Applying overrides to managed dependencies for: {}", (Object)projectGA);
            this.applyOverrides(project, project.getResolvedManagedDependencies(this.session), explicitOverrides, originalOverrides);
            this.applyExplicitOverrides(project, project.getResolvedManagedDependencies(this.session), explicitOverrides, this.explicitVersionPropertyUpdateMap);
        }
        this.logger.debug("Applying overrides to concrete dependencies for: {}", (Object)projectGA);
        this.applyOverrides(project, project.getResolvedDependencies(this.session), explicitOverrides, originalOverrides);
        this.applyExplicitOverrides(project, project.getResolvedDependencies(this.session), explicitOverrides, this.explicitVersionPropertyUpdateMap);
        Map<Profile, Map<ArtifactRef, Dependency>> pd = project.getResolvedProfileDependencies(this.session);
        Map<Profile, Map<ArtifactRef, Dependency>> pmd = project.getResolvedProfileManagedDependencies(this.session);
        for (Map<ArtifactRef, Dependency> dependencies : pd.values()) {
            this.applyOverrides(project, (Map<? extends ProjectVersionRef, ? extends InputLocationTracker>)dependencies, explicitOverrides, originalOverrides);
            this.applyExplicitOverrides(project, dependencies, explicitOverrides, this.explicitVersionPropertyUpdateMap);
        }
        for (Map<ArtifactRef, Dependency> dependencies : pmd.values()) {
            this.applyOverrides(project, dependencies, explicitOverrides, originalOverrides);
            this.applyExplicitOverrides(project, dependencies, explicitOverrides, this.explicitVersionPropertyUpdateMap);
        }
        Map<ProjectVersionRef, Plugin> resolvedPlugins = project.getAllResolvedPlugins(this.session);
        this.applyPlugins(project, resolvedPlugins, explicitOverrides, originalOverrides);
        this.applyExplicitOverrides(project, resolvedPlugins, explicitOverrides, this.explicitVersionPropertyUpdateMap);
        Map<ProjectVersionRef, Plugin> resolvedManagedPlugins = project.getResolvedManagedPlugins(this.session);
        this.applyPlugins(project, resolvedManagedPlugins, explicitOverrides, originalOverrides);
        this.applyExplicitOverrides(project, resolvedManagedPlugins, explicitOverrides, this.explicitVersionPropertyUpdateMap);
        for (Map<ProjectVersionRef, Plugin> map : project.getAllResolvedProfilePlugins(this.session).values()) {
            this.applyPlugins(project, map, explicitOverrides, originalOverrides);
            this.applyExplicitOverrides(project, map, explicitOverrides, this.explicitVersionPropertyUpdateMap);
        }
        for (Map<ProjectVersionRef, Plugin> map : project.getResolvedProfileManagedPlugins(this.session).values()) {
            this.applyPlugins(project, map, explicitOverrides, originalOverrides);
            this.applyExplicitOverrides(project, map, explicitOverrides, this.explicitVersionPropertyUpdateMap);
        }
        List<Map<ArtifactRef, Dependency>> list = project.getAllResolvedPluginDependencies(this.session);
        for (Map<ArtifactRef, Dependency> depMap : list) {
            this.applyOverrides(project, depMap, explicitOverrides, originalOverrides);
            this.applyExplicitOverrides(project, depMap, explicitOverrides, this.explicitVersionPropertyUpdateMap);
        }
    }

    private void applyPlugins(Project project, Map<ProjectVersionRef, Plugin> plugins, WildcardMap<String> explicitOverrides, Map<ArtifactRef, String> overrides) throws ManipulationException {
        List<PluginReference> refs = DependencyPluginUtils.findPluginReferences(this.galleyWrapper, project, plugins);
        HashMap<SimpleProjectVersionRef, PluginReference> pluginsWithDeps = new HashMap<SimpleProjectVersionRef, PluginReference>();
        for (PluginReference reference : refs) {
            if (reference.getVersion() == null) continue;
            String resolvedVersion = PropertyResolver.resolveInheritedProperties(this.session, project, reference.getVersion());
            SimpleProjectVersionRef resolvedRef = new SimpleProjectVersionRef(reference.getGroupId(), reference.getArtifactId(), resolvedVersion);
            pluginsWithDeps.put(resolvedRef, reference);
        }
        this.logger.debug("Located plugins with resolved artifact references: {}", (Object)pluginsWithDeps);
        this.applyOverrides(project, pluginsWithDeps, explicitOverrides, overrides);
        this.applyExplicitOverrides(project, pluginsWithDeps, explicitOverrides, this.explicitVersionPropertyUpdateMap);
    }

    private Map<ArtifactRef, String> applyOverrides(Project project, Map<? extends ProjectVersionRef, ? extends InputLocationTracker> dependencies, WildcardMap<String> explicitOverrides, Map<ArtifactRef, String> overrides) throws ManipulationException {
        LinkedHashMap<ArtifactRef, String> unmatchedVersionOverrides = new LinkedHashMap<ArtifactRef, String>(overrides);
        if (dependencies == null || dependencies.isEmpty()) {
            return unmatchedVersionOverrides;
        }
        CommonState commonState = this.session.getState(CommonState.class);
        boolean strict = commonState.isStrict();
        for (Map.Entry<? extends ProjectVersionRef, ? extends InputLocationTracker> e : dependencies.entrySet()) {
            ProjectVersionRef dependency = e.getKey();
            SimpleProjectRef depPr = new SimpleProjectRef(dependency.getGroupId(), dependency.getArtifactId());
            for (Map.Entry<ArtifactRef, String> entry : overrides.entrySet()) {
                ProjectRef groupIdArtifactId = entry.getKey().asProjectRef();
                if (!((Object)depPr).equals(groupIdArtifactId)) continue;
                DependencyPluginWrapper wrapper = new DependencyPluginWrapper(e.getValue());
                String oldVersion = wrapper.getVersion();
                String overrideVersion = entry.getValue();
                String resolvedValue = dependency.getVersionString();
                if (StringUtils.isEmpty(overrideVersion)) {
                    this.logger.warn("Unable to align with an empty override version for {}; ignoring", (Object)groupIdArtifactId);
                    continue;
                }
                if (StringUtils.isEmpty(oldVersion)) {
                    this.logger.debug("Dependency is a managed version for {}; ignoring", (Object)groupIdArtifactId);
                    continue;
                }
                if (oldVersion.equals("${project.version}") || oldVersion.contains("$") && project.getVersion().equals(resolvedValue)) {
                    this.logger.debug("Dependency {} with original version {} and project version {} for {} references ${project.version} so skipping.", dependency, oldVersion, project.getVersion(), project.getPom());
                    continue;
                }
                if (explicitOverrides.containsKey(depPr)) {
                    this.logger.debug("Dependency {} matches known explicit override so not performing initial override pass.", (Object)depPr);
                    unmatchedVersionOverrides.remove(entry.getKey());
                    continue;
                }
                if (strict && oldVersion.contains("$") && !PropertiesUtils.checkStrictValue(this.session, resolvedValue, overrideVersion)) {
                    this.logger.debug("Original fully resolved version {} for {} does not match override version {} -> {} so ignoring", resolvedValue, dependency, entry.getKey(), overrideVersion);
                    if (commonState.isFailOnStrictViolation()) {
                        throw new ManipulationException("For {} replacing original property version {} (fully resolved: {} ) with new version {} for {} violates the strict version-alignment rule!", ((Object)depPr).toString(), wrapper.getVersion(), resolvedValue, entry.getKey().getVersionString(), entry.getKey().asProjectRef().toString());
                    }
                    this.logger.warn("Replacing original property version {} with new version {} for {} violates the strict version-alignment rule!", resolvedValue, overrideVersion, wrapper.getVersion());
                    continue;
                }
                if (!PropertiesUtils.cacheProperty(this.session, project, this.versionPropertyUpdateMap, oldVersion, overrideVersion, entry.getKey(), false)) {
                    if (strict && !PropertiesUtils.checkStrictValue(this.session, resolvedValue, overrideVersion)) {
                        if (commonState.isFailOnStrictViolation()) {
                            throw new ManipulationException("Replacing original version {} in dependency {} with new version {} violates the strict version-alignment rule!", oldVersion, groupIdArtifactId, overrideVersion);
                        }
                        this.logger.warn("Replacing original version {} in dependency {} with new version {} violates the strict version-alignment rule!", oldVersion, groupIdArtifactId, overrideVersion);
                    } else {
                        this.logger.debug("Altered dependency {} : {} -> {}", groupIdArtifactId, oldVersion, overrideVersion);
                        if (oldVersion.contains("${")) {
                            String replaceVersion;
                            String suffix = PropertiesUtils.getSuffix(this.session);
                            if (commonState.isStrictIgnoreSuffix() && oldVersion.contains(suffix)) {
                                replaceVersion = StringUtils.substringBefore(oldVersion, suffix);
                                replaceVersion = replaceVersion + suffix + StringUtils.substringAfter(overrideVersion, suffix);
                            } else {
                                replaceVersion = overrideVersion;
                            }
                            this.logger.debug("Resolved value is {} and replacement version is {}", (Object)resolvedValue, (Object)replaceVersion);
                            wrapper.setVersion(replaceVersion);
                        } else {
                            wrapper.setVersion(overrideVersion);
                        }
                    }
                }
                unmatchedVersionOverrides.remove(entry.getKey());
            }
        }
        return unmatchedVersionOverrides;
    }

    private Map<ArtifactRef, String> removeReactorGAs(Map<ArtifactRef, String> versionOverrides) {
        LinkedHashMap<ArtifactRef, String> reducedVersionOverrides = new LinkedHashMap<ArtifactRef, String>(versionOverrides);
        Iterator it = reducedVersionOverrides.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            this.session.getProjects().forEach(p -> {
                if (((ArtifactRef)e.getKey()).getGroupId().equals(p.getGroupId()) && ((ArtifactRef)e.getKey()).getArtifactId().equals(p.getArtifactId())) {
                    it.remove();
                }
            });
        }
        return reducedVersionOverrides;
    }

    private void validateDependenciesUpdatedProperty(CommonState cState, Project p, Map<ArtifactRef, Dependency> dependencies) throws ManipulationException {
        for (Map.Entry<ArtifactRef, Dependency> entry : dependencies.entrySet()) {
            ArtifactRef pvr = entry.getKey();
            Dependency dependency = entry.getValue();
            String versionProperty = dependency.getVersion();
            if (!StringUtils.startsWith(versionProperty, "${")) continue;
            PropertiesUtils.verifyPropertyMapping(cState, p, this.versionPropertyUpdateMap, pvr, PropertiesUtils.extractPropertyName(versionProperty));
        }
    }
}

