/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsUtils;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.util.ProfileUtils;
import org.commonjava.maven.ext.common.util.PropertyResolver;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.impl.Manipulator;
import org.commonjava.maven.ext.core.state.RepoReportingState;
import org.commonjava.maven.ext.io.SettingsIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="enforce-repo-reporting-removal")
@Singleton
public class RepoAndReportingRemovalManipulator
implements Manipulator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SettingsIO settingsWriter;
    private ManipulationSession session;

    @Inject
    public RepoAndReportingRemovalManipulator(SettingsIO settingsWriter) {
        this.settingsWriter = settingsWriter;
    }

    @Override
    public void init(ManipulationSession session) {
        this.session = session;
        session.setState(new RepoReportingState(session.getUserProperties()));
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects) throws ManipulationException {
        RepoReportingState state = this.session.getState(RepoReportingState.class);
        if (!this.session.isEnabled() || !state.isEnabled()) {
            this.logger.debug("{}: Nothing to do!", (Object)this.getClass().getSimpleName());
            return Collections.emptySet();
        }
        HashSet<Project> changed = new HashSet<Project>();
        Settings backupSettings = new Settings();
        Profile backupProfile = new Profile();
        backupProfile.setId("removed-by-pme");
        backupSettings.addActiveProfile("removed-by-pme");
        for (Project project : projects) {
            Repository repository;
            this.logger.debug("Applying changes to: {}:{}", (Object)project.getGroupId(), (Object)project.getArtifactId());
            Model model = project.getModel();
            Iterator<Repository> it = model.getRepositories().iterator();
            while (it.hasNext()) {
                repository = it.next();
                if (!this.removeRepository(state, repository)) continue;
                this.processRepository(this.session, project, repository);
                if (!backupProfile.getRepositories().contains(repository)) {
                    backupProfile.addRepository(repository);
                }
                it.remove();
                changed.add(project);
            }
            it = model.getPluginRepositories().iterator();
            while (it.hasNext()) {
                repository = it.next();
                if (!this.removeRepository(state, repository)) continue;
                this.processRepository(this.session, project, repository);
                if (!backupProfile.getPluginRepositories().contains(repository)) {
                    backupProfile.addPluginRepository(repository);
                }
                it.remove();
                changed.add(project);
            }
            if (model.getReporting() != null) {
                model.setReporting(null);
                changed.add(project);
            }
            List<Profile> profiles = ProfileUtils.getProfiles(this.session, model);
            for (Profile profile : profiles) {
                Repository repository2;
                Profile repoProfile = new Profile();
                repoProfile.setId(profile.getId());
                it = profile.getRepositories().iterator();
                while (it.hasNext()) {
                    repository2 = it.next();
                    if (!this.removeRepository(state, repository2)) continue;
                    this.processRepository(this.session, project, repository2);
                    if (!repoProfile.getRepositories().contains(repository2)) {
                        repoProfile.addRepository(repository2);
                    }
                    if (!backupSettings.getActiveProfiles().contains(profile.getId())) {
                        backupSettings.addActiveProfile(profile.getId());
                    }
                    it.remove();
                    changed.add(project);
                }
                it = profile.getPluginRepositories().iterator();
                while (it.hasNext()) {
                    repository2 = it.next();
                    if (!this.removeRepository(state, repository2)) continue;
                    this.processRepository(this.session, project, repository2);
                    if (!repoProfile.getPluginRepositories().contains(repository2)) {
                        repoProfile.addPluginRepository(repository2);
                    }
                    if (!backupSettings.getActiveProfiles().contains(profile.getId())) {
                        backupSettings.addActiveProfile(profile.getId());
                    }
                    it.remove();
                    changed.add(project);
                }
                if (profile.getReporting() != null) {
                    profile.setReporting(null);
                    changed.add(project);
                }
                if (repoProfile.getRepositories().isEmpty() && repoProfile.getPluginRepositories().isEmpty()) continue;
                backupSettings.addProfile(SettingsUtils.convertToSettingsProfile(repoProfile));
            }
        }
        if (!backupProfile.getRepositories().isEmpty() || !backupProfile.getPluginRepositories().isEmpty()) {
            backupSettings.addProfile(SettingsUtils.convertToSettingsProfile(backupProfile));
            String settingsFilePath = state.getRemovalBackupSettings();
            if (!StringUtils.isEmpty(settingsFilePath)) {
                File settingsFile;
                if (settingsFilePath.equals("settings.xml")) {
                    String topDir = this.session.getTargetDir().getParentFile().getPath();
                    settingsFile = new File(topDir, settingsFilePath);
                } else {
                    settingsFile = new File(settingsFilePath);
                }
                this.settingsWriter.update(backupSettings, settingsFile);
            }
        }
        return changed;
    }

    private void processRepository(ManipulationSession session, Project project, Repository repository) throws ManipulationException {
        repository.setUrl(PropertyResolver.resolveInheritedProperties(session, project, repository.getUrl()));
        repository.setId(PropertyResolver.resolveInheritedProperties(session, project, repository.getId()));
        repository.setName(PropertyResolver.resolveInheritedProperties(session, project, repository.getName()));
        if (StringUtils.isBlank(repository.getName())) {
            repository.setName(repository.getId());
        }
    }

    private boolean removeRepository(RepoReportingState state, Repository repo) {
        String url;
        boolean result = true;
        if (state.ignoreLocal() && ((url = repo.getUrl()).startsWith("file:") || url.startsWith("http://localhost") || url.startsWith("https://localhost") || url.startsWith("http://127.0.0.1") || url.startsWith("https://127.0.0.1") || url.startsWith("http://::1") || url.startsWith("https://::1"))) {
            result = false;
        }
        return result;
    }

    @Override
    public int getExecutionIndex() {
        return 50;
    }
}

