/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.util.PropertyResolver;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.impl.Version;
import org.commonjava.maven.ext.core.state.VersioningState;
import org.commonjava.maven.ext.core.util.IdUtils;
import org.commonjava.maven.ext.io.resolver.GalleyAPIWrapper;
import org.commonjava.maven.galley.maven.GalleyMavenException;
import org.commonjava.maven.galley.maven.model.view.meta.MavenMetadataView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class VersionCalculator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final GalleyAPIWrapper readerWrapper;

    @Inject
    public VersionCalculator(GalleyAPIWrapper readerWrapper) {
        this.readerWrapper = readerWrapper;
    }

    public Map<ProjectVersionRef, String> calculateVersioningChanges(List<Project> projects, ManipulationSession session) throws ManipulationException {
        String modifiedVersion;
        String originalVersion;
        VersioningState state = session.getState(VersioningState.class);
        HashMap<ProjectVersionRef, String> versionsByGAV = new HashMap<ProjectVersionRef, String>();
        HashSet<String> versionsWithBuildNums = new HashSet<String>();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Got the following version suffixes:{}  Static: {}{}  Incremental: {}", System.lineSeparator(), state.getSuffix(), System.lineSeparator(), state.getIncrementalSerialSuffix());
            this.logger.debug("Got the following version override: {}", (Object)state.getOverride());
        }
        for (Project project : projects) {
            originalVersion = PropertyResolver.resolveInheritedProperties(session, project, project.getVersion());
            modifiedVersion = this.calculate(project.getGroupId(), project.getArtifactId(), originalVersion, session);
            this.logger.debug("Caching version against project {} with parent {} and modified version {}", project.getKey(), project.getModelParent(), modifiedVersion);
            versionsByGAV.put(project.getKey(), modifiedVersion);
            if (!Version.hasBuildNumber(modifiedVersion)) continue;
            versionsWithBuildNums.add(modifiedVersion);
        }
        this.logger.debug("Syncing projects within reactor...");
        for (Project project : projects) {
            originalVersion = project.getVersion();
            modifiedVersion = (String)versionsByGAV.get(project.getKey());
            int buildNumber = Version.findHighestMatchingBuildNumber(modifiedVersion, versionsWithBuildNums);
            if (buildNumber > 0) {
                String paddedBuildNum = StringUtils.leftPad(Integer.toString(buildNumber), Version.getBuildNumberPadding(state.getSuffix() == null ? state.getIncrementalSerialSuffixPadding() : 0, versionsWithBuildNums), '0');
                modifiedVersion = Version.setBuildNumber(modifiedVersion, paddedBuildNum);
            }
            versionsWithBuildNums.add(modifiedVersion);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{} has updated version: {}. Marking for rewrite.", (Object)IdUtils.gav(project), (Object)modifiedVersion);
            }
            if (originalVersion.equals(modifiedVersion)) continue;
            versionsByGAV.put(project.getKey(), modifiedVersion);
        }
        return versionsByGAV;
    }

    protected String calculate(String groupId, String artifactId, String version, ManipulationSession session) throws ManipulationException {
        return this.calculate(groupId, artifactId, version, session.getState(VersioningState.class));
    }

    public String calculate(String groupId, String artifactId, String version, VersioningState state) throws ManipulationException {
        String incrementalSuffix = state.getIncrementalSerialSuffix();
        String staticSuffix = state.getSuffix();
        String override = state.getOverride();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Got the following original version: {} for groupId:artifactId {}:{}", version, groupId, artifactId);
        }
        String newVersion = version;
        if (state.getSuffixAlternatives().size() > 0) {
            this.logger.debug("Got alternate suffixes of {}", (Object)state.getSuffixAlternatives());
            newVersion = VersionCalculator.handleAlternate(state, version);
            this.logger.debug("Resetting version {} to {}", (Object)version, (Object)newVersion);
        }
        if (override != null) {
            newVersion = override;
        }
        if (staticSuffix != null) {
            newVersion = Version.appendQualifierSuffix(newVersion, staticSuffix);
        } else if (incrementalSuffix != null) {
            Set<String> versionCandidates = this.getVersionCandidates(state, groupId, artifactId);
            int highestRemoteBuildNumPlusOne = Version.findHighestMatchingBuildNumber(newVersion = Version.appendQualifierSuffix(newVersion, incrementalSuffix), versionCandidates) + 1;
            if (highestRemoteBuildNumPlusOne > Version.getIntegerBuildNumber(newVersion)) {
                String paddedBuildNumber = StringUtils.leftPad(Integer.toString(highestRemoteBuildNumPlusOne), Version.getBuildNumberPadding(state.getIncrementalSerialSuffixPadding(), versionCandidates), '0');
                newVersion = Version.setBuildNumber(newVersion, paddedBuildNumber);
            }
        }
        if (!state.isPreserveSnapshot()) {
            newVersion = Version.removeSnapshot(newVersion);
        }
        if (state.isOsgi()) {
            newVersion = Version.getOsgiVersion(newVersion);
        }
        return newVersion;
    }

    protected Set<String> getVersionCandidates(VersioningState state, String groupId, String artifactId) throws ManipulationException {
        HashSet<String> versionCandidates = new HashSet<String>();
        Map<ProjectRef, Set<String>> rm = state.getRESTMetadata();
        if (rm != null) {
            if (!rm.isEmpty() && rm.get(new SimpleProjectRef(groupId, artifactId)) != null) {
                versionCandidates.addAll((Collection<String>)rm.get(new SimpleProjectRef(groupId, artifactId)));
            }
        } else {
            versionCandidates.addAll(this.getMetadataVersions(groupId, artifactId));
        }
        return versionCandidates;
    }

    private Set<String> getMetadataVersions(String groupId, String artifactId) throws ManipulationException {
        this.logger.debug("Reading available versions from repository metadata for: {}:{}", (Object)groupId, (Object)artifactId);
        HashSet<String> versions = new HashSet<String>();
        try {
            if (this.readerWrapper != null) {
                MavenMetadataView metadataView = this.readerWrapper.readMetadataView(new SimpleProjectRef(groupId, artifactId));
                versions.addAll(metadataView.resolveXPathToAggregatedStringList("/metadata/versioning/versions/version", true, -1));
            }
        }
        catch (GalleyMavenException e) {
            throw new ManipulationException("Failed to resolve metadata for: {}:{}", groupId, artifactId, e);
        }
        return versions;
    }

    protected static String handleAlternate(VersioningState state, String version) {
        for (String suffix : state.getSuffixAlternatives()) {
            String suffixStripRegExp = "(.*)([.|-])(" + suffix + "-\\d+)";
            Pattern suffixStripPattern = Pattern.compile(suffixStripRegExp);
            Matcher suffixMatcher = suffixStripPattern.matcher(version);
            if (!suffixMatcher.matches() || version.contains(state.getRebuildSuffix())) continue;
            return suffixMatcher.group(1);
        }
        return version;
    }
}

