/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.state;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.model.Plugin;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.core.state.DependencyState;
import org.commonjava.maven.ext.core.state.State;
import org.commonjava.maven.ext.core.util.IdUtils;
import org.commonjava.maven.ext.core.util.PropertiesUtils;

public class PluginState
implements State {
    private static final String PLUGIN_SOURCE = "pluginSource";
    private static final String PLUGIN_MANAGEMENT_POM_PROPERTY = "pluginManagement";
    private static final String PLUGIN_MANAGEMENT_PRECEDENCE = "pluginManagementPrecedence";
    private static final String PLUGIN_OVERRIDE_PREFIX = "pluginOverride.";
    private List<ProjectVersionRef> remotePluginMgmt;
    private Precedence configPrecedence;
    private final Set<Plugin> remoteRESTplugins = new HashSet<Plugin>();
    private PluginPrecedence precedence;
    private Map<String, String> pluginOverride;

    public PluginState(Properties userProps) throws ManipulationException {
        this.initialise(userProps);
    }

    @Override
    public void initialise(Properties userProps) throws ManipulationException {
        this.remotePluginMgmt = IdUtils.parseGAVs(userProps.getProperty(PLUGIN_MANAGEMENT_POM_PROPERTY));
        this.pluginOverride = PropertiesUtils.getPropertiesByPrefix(userProps, PLUGIN_OVERRIDE_PREFIX);
        switch (Precedence.valueOf(userProps.getProperty(PLUGIN_MANAGEMENT_PRECEDENCE, Precedence.REMOTE.toString()).toUpperCase())) {
            case LOCAL: {
                this.configPrecedence = Precedence.LOCAL;
                break;
            }
            default: {
                this.configPrecedence = Precedence.REMOTE;
            }
        }
        switch (PluginPrecedence.valueOf(userProps.getProperty(PLUGIN_SOURCE, userProps.getProperty("dependencySource", DependencyState.DependencyPrecedence.BOM.toString())).toUpperCase())) {
            case REST: {
                this.precedence = PluginPrecedence.REST;
                break;
            }
            case BOM: {
                this.precedence = PluginPrecedence.BOM;
                break;
            }
            case RESTBOM: {
                this.precedence = PluginPrecedence.RESTBOM;
                break;
            }
            case BOMREST: {
                this.precedence = PluginPrecedence.BOMREST;
                break;
            }
            case NONE: {
                this.precedence = PluginPrecedence.NONE;
                break;
            }
            default: {
                throw new ManipulationException("Unknown value {} for {}", userProps.getProperty(PLUGIN_SOURCE), PLUGIN_SOURCE);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.precedence != PluginPrecedence.NONE && this.remotePluginMgmt != null && !this.remotePluginMgmt.isEmpty() || !this.remoteRESTplugins.isEmpty() || !this.pluginOverride.isEmpty();
    }

    public void setRemoteRESTOverrides(Map<ArtifactRef, String> overrides) {
        for (Map.Entry<ArtifactRef, String> entry : overrides.entrySet()) {
            ArtifactRef a = entry.getKey();
            Plugin p = new Plugin();
            p.setGroupId(a.getGroupId());
            p.setArtifactId(a.getArtifactId());
            p.setVersion(entry.getValue());
            this.remoteRESTplugins.add(p);
        }
    }

    public Set<Plugin> getRemoteRESTOverrides() {
        return this.remoteRESTplugins;
    }

    public List<ProjectVersionRef> getRemotePluginMgmt() {
        return this.remotePluginMgmt;
    }

    public Precedence getConfigPrecedence() {
        return this.configPrecedence;
    }

    public Set<Plugin> getRemoteRESTplugins() {
        return this.remoteRESTplugins;
    }

    public PluginPrecedence getPrecedence() {
        return this.precedence;
    }

    public Map<String, String> getPluginOverride() {
        return this.pluginOverride;
    }

    public static enum Precedence {
        REMOTE,
        LOCAL;

    }

    public static enum PluginPrecedence {
        REST,
        BOM,
        RESTBOM,
        BOMREST,
        NONE;

    }
}

