/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.filearc.internal.util;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ZipUtils {
    private static final String ARCHIVE_URI_PATTERN = "(zip|jar):\\/?(\\/?file:\\/?)?(\\/[^!]+)(\\!\\/?(.*))?";

    private ZipUtils() {
    }

    public static boolean isJar(String uri) {
        return uri.startsWith("jar:");
    }

    public static String getArchivePath(String uri) {
        Matcher m = Pattern.compile(ARCHIVE_URI_PATTERN).matcher(uri);
        if (m.matches()) {
            return m.group(5);
        }
        return null;
    }

    public static File getArchiveFile(String uri) {
        Matcher m = Pattern.compile(ARCHIVE_URI_PATTERN).matcher(uri);
        if (m.matches()) {
            return new File(m.group(3));
        }
        return null;
    }
}

