/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.model.view;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.commonjava.maven.galley.maven.GalleyMavenException;
import org.commonjava.maven.galley.maven.model.view.MavenXmlView;
import org.w3c.dom.Node;

public class MavenXmlMixin<T> {
    public static final String[] DEPENDENCY_MIXIN = new String[]{"dependencyManagement/dependencies/dependency", "dependencyManagement//dependency"};
    private final Set<String> subPaths;
    private final MavenXmlView<T> mixin;

    public MavenXmlMixin(MavenXmlView<T> mixin, Set<String> pathPatterns) {
        this.mixin = mixin;
        this.subPaths = pathPatterns;
    }

    public MavenXmlMixin(MavenXmlView<T> mixin, String ... pathPatterns) {
        this.mixin = mixin;
        this.subPaths = new HashSet<String>(Arrays.asList(pathPatterns));
    }

    public boolean matches(String path) {
        for (String pattern : this.subPaths) {
            if (!path.contains(pattern)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getSubPaths() {
        return this.subPaths;
    }

    public MavenXmlView<T> getMixin() {
        return this.mixin;
    }

    public String resolveXPathToRawString(String path) throws GalleyMavenException {
        return this.mixin.resolveXPathToRawString(path, true, -1);
    }

    public Node resolveXPathToNode(String path) throws GalleyMavenException {
        return this.mixin.resolveXPathToNode(path, true, -1);
    }

    public String toString() {
        return "Mixin [ref: " + this.mixin.getRef() + ", paths: " + this.subPaths + "]";
    }
}

