/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.model.view;

import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import org.commonjava.maven.galley.maven.model.view.MavenGAVView;
import org.commonjava.maven.galley.maven.model.view.MavenPomView;
import org.commonjava.maven.galley.maven.model.view.OriginInfo;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PropertiesView
extends MavenGAVView {
    public PropertiesView(MavenPomView pomView, Element element, OriginInfo originInfo) {
        super(pomView, element, originInfo);
    }

    public Properties getProperties() {
        List<Element> elements = this.getElements("*");
        Properties result = new Properties();
        if (elements != null) {
            for (Element e : elements) {
                Node value = e.getFirstChild();
                result.setProperty(e.getNodeName(), value == null ? "" : this.getPomView().resolveExpressions(e.getFirstChild().getNodeValue(), new String[0]));
            }
        }
        return result;
    }

    public static Properties aggregateProperties(List<PropertiesView> lpv) {
        Properties result = new Properties();
        ListIterator<PropertiesView> iterator = lpv.listIterator(lpv.size());
        while (iterator.hasPrevious()) {
            Properties p = iterator.previous().getProperties();
            for (String key : p.stringPropertyNames()) {
                if (!result.containsKey(key)) {
                    result.setProperty(key, p.getProperty(key));
                    continue;
                }
                if (p.getProperty(key).length() <= 0 || p.getProperty(key).startsWith("${")) continue;
                result.setProperty(key, p.getProperty(key));
            }
        }
        return result;
    }
}

