/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import kong.unirest.json.JSONElement;
import kong.unirest.json.JSONException;
import kong.unirest.json.JSONObject;

public class JSONArray
extends JSONElement
implements Iterable<Object> {
    private final transient JsonArray obj;

    public JSONArray() {
        this(new JsonArray());
    }

    public JSONArray(String jsonString) {
        this(JSONArray.fromJson(jsonString, JsonArray.class));
    }

    public JSONArray(Collection<?> collection) {
        this(JSONArray.toJsonArray(collection.stream().map(JSONElement::unwrap).collect(Collectors.toList())));
    }

    public JSONArray(Object array) {
        this(JSONArray.toJsonArray(array));
    }

    private static JsonArray toJsonArray(Object array) {
        if (array == null || !array.getClass().isArray()) {
            throw new JSONException("JSONArray initial value should be a string or collection or array.");
        }
        ArrayList<Object> pre = new ArrayList<Object>();
        for (Object o : (Object[])array) {
            pre.add(JSONArray.unwrap(o));
        }
        return JSONArray.toJsonArray(pre);
    }

    JSONArray(JsonArray array) {
        super(array);
        this.obj = array;
    }

    JSONArray(JsonElement jsonElement) {
        this(jsonElement.getAsJsonArray());
    }

    public int length() {
        return this.obj.size();
    }

    public JSONArray put(JSONObject object) {
        this.obj.add(object.asElement());
        return this;
    }

    public JSONArray put(JSONArray array) {
        this.obj.add(array.obj);
        return this;
    }

    public JSONArray put(double num) throws JSONException {
        this.obj.add(num);
        return this;
    }

    public JSONArray put(int num) {
        this.obj.add(num);
        return this;
    }

    public JSONArray put(long num) {
        this.obj.add(num);
        return this;
    }

    public JSONArray put(float num) throws JSONException {
        this.obj.add(Float.valueOf(num));
        return this;
    }

    public JSONArray put(Number num) {
        this.obj.add(num);
        return this;
    }

    public JSONArray put(boolean bool) {
        this.obj.add(bool);
        return this;
    }

    public JSONArray put(String str) {
        this.obj.add(str);
        return this;
    }

    public JSONArray put(Map map) {
        this.obj.add(JSONArray.toJsonObject(map));
        return this;
    }

    public JSONArray put(Collection collection) {
        this.obj.add(JSONArray.toJsonArray(collection));
        return this;
    }

    public <T extends Enum> JSONArray put(T enumValue) {
        return this.put(enumValue.name());
    }

    public JSONArray put(int index, long number) throws JSONException {
        return this.put(index, new JsonPrimitive(number));
    }

    public JSONArray put(int index, double number) throws JSONException {
        return this.put(index, new JsonPrimitive(number));
    }

    public JSONArray put(int index, boolean bool) throws JSONException {
        return this.put(index, new JsonPrimitive(bool));
    }

    public JSONArray put(int index, Object object) throws JSONException {
        if (object == null) {
            this.put(index, JsonNull.INSTANCE);
        } else if (object instanceof Number) {
            this.put(index, (Number)object);
        } else if (object instanceof Boolean) {
            this.put(index, (Boolean)object);
        } else if (object instanceof JSONObject) {
            this.put(index, ((JSONObject)object).getElement());
        } else if (object instanceof JSONArray) {
            this.put(index, ((JSONArray)object).getElement());
        } else {
            this.put(index, String.valueOf(object));
        }
        return this;
    }

    public JSONArray put(int index, float number) throws JSONException {
        return this.put(index, new JsonPrimitive(Float.valueOf(number)));
    }

    public JSONArray put(int index, int number) throws JSONException {
        return this.put(index, new JsonPrimitive(number));
    }

    public JSONArray put(int index, Number number) {
        return this.put(index, number == null ? JsonNull.INSTANCE : new JsonPrimitive(number));
    }

    public JSONArray put(int index, String string) {
        return this.put(index, string == null ? JsonNull.INSTANCE : new JsonPrimitive(string));
    }

    public JSONArray put(int index, Map map) throws JSONException {
        return this.put(index, JSONArray.toJsonObject(map));
    }

    public JSONArray put(int index, Collection collection) throws JSONException {
        return this.put(index, JSONArray.toJsonArray(collection));
    }

    public <T extends Enum> JSONArray put(int index, T enumValue) {
        return this.put(index, enumValue == null ? null : enumValue.name());
    }

    private JSONArray put(int index, JsonElement o) {
        while (this.obj.size() < index + 1) {
            this.obj.add(JsonNull.INSTANCE);
        }
        if (index < this.obj.size()) {
            this.obj.set(index, o);
        } else if (index == this.obj.size()) {
            this.obj.add(o);
        }
        return this;
    }

    public JSONArray put(Object object) {
        if (object == null) {
            this.obj.add(JsonNull.INSTANCE);
        } else if (object instanceof Number) {
            this.put((Number)object);
        } else if (object instanceof Boolean) {
            this.put((Boolean)object);
        } else if (object instanceof JSONObject) {
            this.put((JSONObject)object);
        } else if (object instanceof JSONArray) {
            this.put((JSONArray)object);
        } else {
            this.put(String.valueOf(object));
        }
        return this;
    }

    public Object remove(int index) {
        try {
            JsonElement remove = this.obj.remove(index);
            return MAPPER.apply(remove);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public boolean getBoolean(int index) throws JSONException {
        JsonElement e = this.getElement(index);
        if (!e.isJsonPrimitive() || !e.getAsJsonPrimitive().isBoolean()) {
            throw new JSONException("JSONArray[%s] is not a boolean.", index);
        }
        return e.getAsBoolean();
    }

    public boolean optBoolean(int index) {
        return this.optBoolean(index, false);
    }

    public boolean optBoolean(int index, boolean defaultValue) {
        return this.getOrDefault(() -> this.getElement(index).getAsBoolean(), defaultValue);
    }

    public JSONObject getJSONObject(int index) throws JSONException {
        try {
            return new JSONObject(this.getElement(index));
        }
        catch (IllegalStateException e) {
            throw new JSONException("JSONArray[%s] is not a JSONObject.", index);
        }
    }

    public JSONObject optJSONObject(int index) {
        return this.getOrDefault(() -> new JSONObject(this.getElement(index).getAsJsonObject()), null);
    }

    public double getDouble(int index) throws JSONException {
        return this.tryNumber(() -> this.getElement(index).getAsDouble(), index);
    }

    public double optDouble(int index) {
        return this.optDouble(index, Double.NaN);
    }

    public double optDouble(int index, double defaultValue) {
        return this.getOrDefault(() -> this.getDouble(index), defaultValue);
    }

    public float getFloat(int index) throws JSONException {
        return this.tryNumber(() -> Float.valueOf(this.getElement(index).getAsFloat()), index).floatValue();
    }

    public float optFloat(int index) {
        return this.optFloat(index, Float.NaN);
    }

    public float optFloat(int index, float defaultValue) {
        return this.getOrDefault(() -> Float.valueOf(this.getFloat(index)), Float.valueOf(defaultValue)).floatValue();
    }

    public long getLong(int index) throws JSONException {
        return this.tryNumber(() -> this.getElement(index).getAsLong(), index);
    }

    public long optLong(int index) {
        return this.optLong(index, 0L);
    }

    public long optLong(int index, long defaultValue) {
        return this.getOrDefault(() -> this.getLong(index), defaultValue);
    }

    public Number getNumber(int index) throws JSONException {
        return this.tryNumber(() -> this.getElement(index).getAsInt(), index);
    }

    public Number optNumber(int index) {
        return this.getOrDefault(() -> this.getNumber(index), null);
    }

    public Number optNumber(int index, Number defaultValue) {
        return this.getOrDefault(() -> this.getNumber(index), defaultValue);
    }

    public int getInt(int index) throws JSONException {
        return this.tryNumber(() -> this.getElement(index).getAsInt(), index);
    }

    public int optInt(int index) {
        return this.optInt(index, 0);
    }

    public int optInt(int index, int defaultValue) {
        return this.getOrDefault(() -> this.getInt(index), defaultValue);
    }

    public BigInteger getBigInteger(int index) throws JSONException {
        return this.tryNumber(() -> this.getElement(index).getAsBigInteger(), index);
    }

    public BigInteger optBigInteger(int index, BigInteger defaultValue) {
        return this.getOrDefault(() -> this.getBigInteger(index), defaultValue);
    }

    public BigDecimal getBigDecimal(int index) throws JSONException {
        return this.tryNumber(() -> this.getElement(index).getAsBigDecimal(), index);
    }

    public BigDecimal optBigDecimal(int index, BigDecimal defaultValue) {
        return this.getOrDefault(() -> this.getBigDecimal(index), defaultValue);
    }

    public String getString(int index) throws JSONException {
        return this.getElement(index).getAsString();
    }

    public String optString(int index) {
        return this.optString(index, "");
    }

    public String optString(int index, String defaultValue) {
        return this.getOrDefault(() -> this.getString(index), defaultValue);
    }

    public JSONArray getJSONArray(int index) throws JSONException {
        try {
            return new JSONArray(this.getElement(index).getAsJsonArray());
        }
        catch (IllegalStateException e) {
            throw new JSONException("JSONArray[%s] is not a JSONArray.", index);
        }
    }

    public JSONArray optJSONArray(int index) {
        return this.getOrDefault(() -> this.getJSONArray(index), null);
    }

    public <T extends Enum<T>> T getEnum(Class<T> enumClass, int index) throws JSONException {
        String raw = this.getElement(index).getAsString();
        try {
            return Enum.valueOf(enumClass, raw);
        }
        catch (IllegalArgumentException e) {
            throw new JSONException("JSONArray[%s] is not an enum of type \"%s\".", index, enumClass.getSimpleName());
        }
    }

    public <T extends Enum<T>> T optEnum(Class<T> enumClass, int index) {
        return this.optEnum(enumClass, index, null);
    }

    public <T extends Enum<T>> T optEnum(Class<T> enumClass, int index, T defaultValue) {
        return (T)this.getOrDefault(() -> this.getEnum(enumClass, index), defaultValue);
    }

    public Object get(int index) throws JSONException {
        return MAPPER.apply(this.obj.get(index));
    }

    public Object opt(int index) {
        try {
            return this.get(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString() {
        return JSONArray.toJson(this.obj);
    }

    public String toString(int indent) throws JSONException {
        return JSONArray.toPrettyJson(this.obj);
    }

    public String join(String token) throws JSONException {
        return StreamSupport.stream(this.obj.spliterator(), false).map(String::valueOf).collect(Collectors.joining(token));
    }

    @Override
    public Iterator<Object> iterator() {
        return this.toList().iterator();
    }

    public boolean similar(Object o) {
        if (!(o instanceof JSONArray)) {
            return false;
        }
        JSONArray cst = (JSONArray)o;
        return this.obj.equals(cst.obj);
    }

    public List toList() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < this.obj.size(); ++i) {
            list.add(this.get(i));
        }
        return list;
    }

    public boolean isNull(int index) {
        return index >= this.obj.size() || this.obj.get(index).isJsonNull();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof JsonArray) {
            return this.obj.equals(o);
        }
        if (o instanceof JSONArray) {
            return this.obj.equals(((JSONArray)o).obj);
        }
        return false;
    }

    public int hashCode() {
        return this.obj.hashCode();
    }

    JsonArray getArray() {
        return this.obj;
    }

    private JsonElement getElement(int index) {
        try {
            return this.obj.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new JSONException("JSONArray[%s] not found.", index);
        }
    }

    private <T> T getOrDefault(Supplier<T> supplier, T defaultValue) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private <T extends Number> T tryNumber(Supplier<T> supplier, int index) {
        try {
            return (T)((Number)supplier.get());
        }
        catch (NumberFormatException e) {
            throw new JSONException("JSONArray[%s] is not a number.", index);
        }
    }

    public JSONObject toJSONObject(JSONArray names) throws JSONException {
        if (names == null || names.isEmpty() || this.isEmpty()) {
            return null;
        }
        JSONObject object = new JSONObject();
        int index = 0;
        for (Object key : names) {
            if (index >= this.length()) break;
            if (key == null) {
                throw new JSONException("JSONArray[%s] not a string.", index);
            }
            object.put(String.valueOf(key), this.get(index));
            ++index;
        }
        return object;
    }

    public boolean isEmpty() {
        return this.obj.size() == 0;
    }
}

