/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.release.phase.ReleasePhase;
import org.apache.maven.shared.release.scm.ReleaseScmCommandException;
import org.apache.maven.shared.release.scm.ReleaseScmRepositoryException;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

@Component(role=ReleasePhase.class, hint="checkout-project-from-scm")
public class CheckoutProjectFromScm
extends AbstractReleasePhase {
    @Requirement
    private ScmRepositoryConfigurator scmRepositoryConfigurator;

    @Override
    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseResult releaseResult = null;
        if (releaseDescriptor.isLocalCheckout()) {
            String providerPart = releaseDescriptor.getScmSourceUrl().substring(0, releaseDescriptor.getScmSourceUrl().indexOf(58, 4));
            String scmPath = releaseDescriptor.getWorkingDirectory();
            do {
                try {
                    if (scmPath.startsWith("/")) {
                        scmPath = scmPath.substring(1);
                    }
                    String scmUrl = providerPart + ":file:///" + scmPath;
                    releaseDescriptor.setScmSourceUrl(scmUrl);
                    this.getLogger().info("Performing a LOCAL checkout from " + releaseDescriptor.getScmSourceUrl());
                    releaseResult = this.performCheckout(releaseDescriptor, releaseEnvironment, reactorProjects);
                }
                catch (ScmException scmEx) {
                    releaseResult = null;
                }
                if (releaseResult != null && releaseResult.getResultCode() != 1) continue;
                releaseResult = null;
                int lastSlashPos = scmPath.lastIndexOf(File.separator);
                if (lastSlashPos > 0) {
                    scmPath = scmPath.substring(0, lastSlashPos);
                    continue;
                }
                throw new ReleaseExecutionException("could not perform a local checkout");
            } while (releaseResult == null);
        } else {
            try {
                releaseResult = this.performCheckout(releaseDescriptor, releaseEnvironment, reactorProjects);
            }
            catch (ScmException e) {
                releaseResult = new ReleaseResult();
                releaseResult.setResultCode(1);
                this.logError(releaseResult, e.getMessage());
                throw new ReleaseExecutionException("An error is occurred in the checkout process: " + e.getMessage(), e);
            }
        }
        return releaseResult;
    }

    private ReleaseResult performCheckout(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException, ScmException {
        ScmProvider provider;
        ScmRepository repository;
        ReleaseResult result = new ReleaseResult();
        this.logInfo(result, "Checking out the project to perform the release ...");
        try {
            repository = this.scmRepositoryConfigurator.getConfiguredRepository(releaseDescriptor, releaseEnvironment.getSettings());
            provider = this.scmRepositoryConfigurator.getRepositoryProvider(repository);
        }
        catch (ScmRepositoryException e) {
            result.setResultCode(1);
            this.logError(result, e.getMessage());
            throw new ReleaseScmRepositoryException(e.getMessage(), e.getValidationMessages());
        }
        catch (NoSuchScmProviderException e) {
            result.setResultCode(1);
            this.logError(result, e.getMessage());
            throw new ReleaseExecutionException("Unable to configure SCM repository: " + e.getMessage(), e);
        }
        MavenProject rootProject = ReleaseUtil.getRootProject(reactorProjects);
        File checkoutDirectory = FileUtils.resolveFile(rootProject.getBasedir(), releaseDescriptor.getCheckoutDirectory());
        if (checkoutDirectory.exists()) {
            try {
                FileUtils.deleteDirectory(checkoutDirectory);
            }
            catch (IOException e) {
                result.setResultCode(1);
                this.logError(result, e.getMessage());
                throw new ReleaseExecutionException("Unable to remove old checkout directory: " + e.getMessage(), e);
            }
        }
        checkoutDirectory.mkdirs();
        CommandParameters commandParameters = new CommandParameters();
        commandParameters.setString(CommandParameter.SHALLOW, Boolean.TRUE.toString());
        CheckOutScmResult scmResult = provider.checkOut(repository, new ScmFileSet(checkoutDirectory), (ScmVersion)new ScmTag(releaseDescriptor.getScmReleaseLabel()), commandParameters);
        if (releaseDescriptor.isLocalCheckout() && !scmResult.isSuccess()) {
            return null;
        }
        String scmRelativePathProjectDirectory = scmResult.getRelativePathProjectDirectory();
        if (StringUtils.isEmpty(scmRelativePathProjectDirectory)) {
            Path rootProjectBasedir;
            Path workingDirectory = Paths.get(releaseDescriptor.getWorkingDirectory(), new String[0]);
            try {
                rootProjectBasedir = rootProject.getBasedir().toPath().toRealPath(LinkOption.NOFOLLOW_LINKS);
            }
            catch (IOException e) {
                throw new ReleaseExecutionException(e.getMessage(), e);
            }
            scmRelativePathProjectDirectory = workingDirectory.relativize(rootProjectBasedir).toString();
        }
        releaseDescriptor.setScmRelativePathProjectDirectory(scmRelativePathProjectDirectory);
        if (!scmResult.isSuccess()) {
            result.setResultCode(1);
            this.logError(result, scmResult.getProviderMessage());
            throw new ReleaseScmCommandException("Unable to checkout from SCM", (ScmResult)scmResult);
        }
        result.setResultCode(0);
        return result;
    }

    @Override
    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseResult result = new ReleaseResult();
        if (releaseDescriptor.isLocalCheckout()) {
            this.logInfo(result, "This would be a LOCAL check out to perform the release ...");
        } else {
            this.logInfo(result, "The project would be checked out to perform the release ...");
        }
        result.setResultCode(0);
        return result;
    }
}

