/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.common.jdom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.TreeMap;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.commonjava.maven.ext.common.jdom.IndentationCounter;
import org.jdom2.Attribute;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.DefaultJDOMFactory;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final String INDENT = "  ";
    private static final String lineSeparator = "\n";
    private static final DefaultJDOMFactory factory = new DefaultJDOMFactory();
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    public static Element updateElement(IndentationCounter counter, Element parent, String name, boolean shouldExist) {
        Element element = parent.getChild(name, parent.getNamespace());
        if (shouldExist) {
            if (element == null) {
                element = factory.element(name, parent.getNamespace());
                Utils.insertAtPreferredLocation(parent, element, counter);
            }
            counter.increaseCount();
        } else if (element != null) {
            Text txt;
            Content previous;
            int index = parent.indexOf(element);
            if (index > 0 && (previous = parent.getContent(index - 1)) instanceof Text && (txt = (Text)previous).getTextTrim().length() == 0) {
                parent.removeContent(txt);
            }
            parent.removeContent(element);
        }
        return element;
    }

    public static Element findAndReplaceXpp3DOM(IndentationCounter counter, Element parent, String name, Xpp3Dom dom) {
        boolean shouldExist = dom != null && (dom.getChildCount() > 0 || dom.getValue() != null);
        Element element = Utils.updateElement(counter, parent, name, shouldExist);
        if (shouldExist) {
            Utils.replaceXpp3DOM(element, dom, new IndentationCounter(counter.getDepth() + 1));
        }
        return element;
    }

    public static void replaceXpp3DOM(Element parent, Xpp3Dom parentDom, IndentationCounter counter) {
        if (parentDom.getChildCount() > 0) {
            Xpp3Dom[] childs = parentDom.getChildren();
            ArrayList<Xpp3Dom> domChilds = new ArrayList<Xpp3Dom>(Arrays.asList(childs));
            ListIterator<Element> it = parent.getChildren().listIterator();
            while (it.hasNext()) {
                Element elem = it.next();
                Iterator<Xpp3Dom> it2 = domChilds.iterator();
                Xpp3Dom corrDom = null;
                while (it2.hasNext()) {
                    Xpp3Dom dm = it2.next();
                    if (!dm.getName().equals(elem.getQualifiedName())) continue;
                    corrDom = dm;
                    break;
                }
                if (corrDom != null) {
                    domChilds.remove(corrDom);
                    Utils.replaceXpp3DOM(elem, corrDom, new IndentationCounter(counter.getDepth() + 1));
                    counter.increaseCount();
                    continue;
                }
                it.remove();
            }
            for (Xpp3Dom dm : domChilds) {
                String[] attributeNames;
                Element elem;
                String rawName = dm.getName();
                String[] parts = rawName.split(":");
                if (parts.length > 1) {
                    String nsId = parts[0];
                    String nsUrl = dm.getAttribute("xmlns:" + nsId);
                    String name = parts[1];
                    if (nsUrl == null) {
                        nsUrl = parentDom.getAttribute("xmlns:" + nsId);
                    }
                    elem = factory.element(name, Namespace.getNamespace(nsId, nsUrl));
                } else {
                    Namespace root = parent.getNamespace();
                    for (Namespace n : Utils.getNamespacesInherited(parent)) {
                        if (n.getPrefix() != null && n.getPrefix().length() != 0) continue;
                        root = n;
                        break;
                    }
                    elem = factory.element(dm.getName(), root);
                }
                for (String attrName : attributeNames = dm.getAttributeNames()) {
                    if (attrName.startsWith("xmlns:")) continue;
                    elem.setAttribute(attrName, dm.getAttribute(attrName));
                }
                Utils.insertAtPreferredLocation(parent, elem, counter);
                counter.increaseCount();
                Utils.replaceXpp3DOM(elem, dm, new IndentationCounter(counter.getDepth() + 1));
            }
        } else if (parentDom.getValue() != null) {
            List<Content> cl = parent.getContent();
            boolean foundCdata = false;
            for (Content c : cl) {
                if (!(c instanceof CDATA)) continue;
                foundCdata = true;
                break;
            }
            if (!foundCdata) {
                if (parent.getText().trim().equals(parentDom.getValue())) {
                    logger.trace("Ignoring during element update as original of '{}' equals (ignoring trimmed whitespace) '{}'", (Object)parent.getText(), (Object)parentDom.getValue());
                } else {
                    parent.setText(parentDom.getValue());
                }
            }
        }
    }

    public static void insertAtPreferredLocation(Element parent, Element child, IndentationCounter counter) {
        int contentIndex = 0;
        int elementCounter = 0;
        Iterator<Content> it = parent.getContent().iterator();
        Text lastText = null;
        int offset = 0;
        while (it.hasNext() && elementCounter <= counter.getCurrentIndex()) {
            Content next = it.next();
            ++offset;
            if (next instanceof Element) {
                ++elementCounter;
                contentIndex += offset;
                offset = 0;
            }
            if (!(next instanceof Text) || !it.hasNext()) continue;
            lastText = (Text)next;
        }
        if (lastText != null && lastText.getTextTrim().length() == 0) {
            lastText = lastText.clone();
        } else {
            StringBuilder starter = new StringBuilder(lineSeparator);
            for (int i = 0; i < counter.getDepth(); ++i) {
                starter.append(INDENT);
            }
            lastText = factory.text(starter.toString());
        }
        if (parent.getContentSize() == 0) {
            Text finalText = lastText.clone();
            String newVersion = finalText.getText().substring(0, finalText.getText().length() - INDENT.length());
            logger.trace("Replacing original text of {} with modified text of {}", (Object)finalText.getText(), (Object)newVersion);
            finalText.setText(newVersion);
            parent.addContent(contentIndex, finalText);
        }
        parent.addContent(contentIndex, child);
        parent.addContent(contentIndex, lastText);
    }

    public static Element findAndReplaceProperties(IndentationCounter counter, Element parent, String name, Properties props) {
        boolean shouldExist = props != null && !props.isEmpty();
        Element element = Utils.updateElement(counter, parent, name, shouldExist);
        if (shouldExist) {
            Iterator<Object> it = props.stringPropertyNames().iterator();
            IndentationCounter innerCounter = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                String key = it.next();
                Utils.findAndReplaceSimpleElement(innerCounter, element, key, (String)props.get(key), null);
            }
            ArrayList<String> lst = new ArrayList<String>(props.stringPropertyNames());
            it = element.getChildren().iterator();
            while (it.hasNext()) {
                Element elem = (Element)it.next();
                String key = elem.getName();
                if (lst.contains(key)) continue;
                it.remove();
            }
        }
        return element;
    }

    public static Element findAndReplaceSimpleElement(IndentationCounter counter, Element parent, String name, String text, String defaultValue) {
        Element element;
        if (defaultValue != null && defaultValue.equals(text) && ((element = parent.getChild(name, parent.getNamespace())) == null || defaultValue.equals(element.getText()))) {
            return element;
        }
        boolean shouldExist = text != null && text.trim().length() >= 0;
        Element element2 = Utils.updateElement(counter, parent, name, shouldExist);
        if (shouldExist) {
            if (element2.getText().trim().equals(text)) {
                logger.trace("Ignoring during element update as original of '{}' equals (ignoring trimmed whitespace) '{}'", (Object)element2.getText(), (Object)text);
            } else {
                element2.setText(text);
            }
        }
        return element2;
    }

    public static Element findAndReplaceSimpleLists(IndentationCounter counter, Element parent, Collection<?> list, String parentName, String childName) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = Utils.updateElement(counter, parent, parentName, shouldExist);
        if (shouldExist) {
            Iterator<?> it = list.iterator();
            Iterator<Element> elIt = element.getChildren(childName, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                String value = (String)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = factory.element(childName, element.getNamespace());
                    Utils.insertAtPreferredLocation(element, el, innerCount);
                }
                logger.trace("TODO: Replacing original text of {} with modified text of {}", (Object)el.getText(), (Object)value);
                el.setText(value);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
        return element;
    }

    static List<Namespace> getNamespacesInherited(Element element) {
        if (element.getParentElement() == null) {
            ArrayList<Namespace> ret = new ArrayList<Namespace>(Utils.getNamespacesInScope(element));
            Iterator<Namespace> it = ret.iterator();
            while (it.hasNext()) {
                Namespace ns = it.next();
                if (ns == Namespace.NO_NAMESPACE || ns == Namespace.XML_NAMESPACE) continue;
                it.remove();
            }
            return Collections.unmodifiableList(ret);
        }
        HashMap<String, Namespace> parents = new HashMap<String, Namespace>();
        for (Namespace ns : Utils.getNamespacesInScope(element.getParentElement())) {
            parents.put(ns.getPrefix(), ns);
        }
        ArrayList<Namespace> al = new ArrayList<Namespace>();
        for (Namespace ns : Utils.getNamespacesInScope(element)) {
            if (ns != parents.get(ns.getPrefix())) continue;
            al.add(ns);
        }
        return Collections.unmodifiableList(al);
    }

    static List<Namespace> getNamespacesInScope(Element element) {
        Element pnt;
        TreeMap<String, Namespace> namespaces = new TreeMap<String, Namespace>();
        namespaces.put(Namespace.XML_NAMESPACE.getPrefix(), Namespace.XML_NAMESPACE);
        namespaces.put(element.getNamespacePrefix(), element.getNamespace());
        if (element.getAdditionalNamespaces() != null) {
            for (Namespace namespace : element.getAdditionalNamespaces()) {
                if (namespaces.containsKey(namespace.getPrefix())) continue;
                namespaces.put(namespace.getPrefix(), namespace);
            }
        }
        if (element.getAttributes() != null) {
            for (Attribute attribute : element.getAttributes()) {
                Namespace ns = attribute.getNamespace();
                if (namespaces.containsKey(ns.getPrefix())) continue;
                namespaces.put(ns.getPrefix(), ns);
            }
        }
        if ((pnt = element.getParentElement()) != null) {
            for (Namespace ns : Utils.getNamespacesInScope(pnt)) {
                if (namespaces.containsKey(ns.getPrefix())) continue;
                namespaces.put(ns.getPrefix(), ns);
            }
        }
        if (pnt == null && !namespaces.containsKey("")) {
            namespaces.put(Namespace.NO_NAMESPACE.getPrefix(), Namespace.NO_NAMESPACE);
        }
        ArrayList<Namespace> arrayList = new ArrayList<Namespace>(namespaces.size());
        arrayList.add(element.getNamespace());
        namespaces.remove(element.getNamespacePrefix());
        arrayList.addAll(namespaces.values());
        return Collections.unmodifiableList(arrayList);
    }

    private Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

