/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.common.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.commonjava.maven.ext.common.ManipulationUncheckedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ManifestUtils {
    private static final Logger logger = LoggerFactory.getLogger(ManifestUtils.class);

    public static String getManifestInformation(Class<?> target) {
        String result;
        block11: {
            result = "";
            if (target == null) {
                throw new ManipulationUncheckedException("No target specified.", new Object[0]);
            }
            try {
                CodeSource cs = target.getProtectionDomain().getCodeSource();
                if (cs == null) {
                    logger.debug("Unable to retrieve manifest for {} as CodeSource was null for the protection domain ({})", (Object)target, (Object)target.getProtectionDomain());
                    break block11;
                }
                URL jarUrl = cs.getLocation();
                if (new File(jarUrl.getPath()).isDirectory()) {
                    logger.debug("Unable to retrieve manifest for {} as location is a directory not a jar ({})", (Object)target, (Object)jarUrl.getPath());
                    break block11;
                }
                try (JarInputStream jarStream = new JarInputStream(jarUrl.openStream());){
                    Manifest manifest = jarStream.getManifest();
                    if (manifest != null) {
                        result = manifest.getMainAttributes().getValue("Implementation-Version");
                        result = result + " ( SHA: " + manifest.getMainAttributes().getValue("Scm-Revision") + " )";
                    }
                }
            }
            catch (IOException e) {
                throw new ManipulationUncheckedException("Error retrieving information from manifest", new Object[]{e});
            }
        }
        return result;
    }

    private ManifestUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

