/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.impl.Manipulator;
import org.commonjava.maven.ext.core.state.ProfileRemovalState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="profile-removal")
@Singleton
public class ProfileRemovalManipulator
implements Manipulator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ManipulationSession session;

    @Override
    public void init(ManipulationSession session) {
        this.session = session;
        session.setState(new ProfileRemovalState(session.getUserProperties()));
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects) {
        ProfileRemovalState state = this.session.getState(ProfileRemovalState.class);
        if (!this.session.isEnabled() || !state.isEnabled()) {
            this.logger.debug("{}: Nothing to do!", (Object)this.getClass().getSimpleName());
            return Collections.emptySet();
        }
        List<String> profilesToRemove = state.getProfileRemoval();
        HashSet<Project> changed = new HashSet<Project>();
        for (Project project : projects) {
            this.logger.info("Applying changes to: {}:{}", (Object)project.getGroupId(), (Object)project.getArtifactId());
            Model model = project.getModel();
            List<Profile> profiles = model.getProfiles();
            Iterator<Profile> i = profiles.iterator();
            block1: while (i.hasNext()) {
                Profile p = i.next();
                for (String id : profilesToRemove) {
                    if (!p.getId().equals(id)) continue;
                    this.logger.debug("Removing profile {}", (Object)p.getId());
                    i.remove();
                    changed.add(project);
                    continue block1;
                }
            }
        }
        return changed;
    }

    @Override
    public int getExecutionIndex() {
        return 55;
    }
}

