/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.ManipulationUncheckedException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.util.PropertyResolver;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.impl.Manipulator;
import org.commonjava.maven.ext.core.state.RangeResolverState;
import org.commonjava.maven.ext.core.state.State;
import org.commonjava.maven.ext.io.resolver.GalleyAPIWrapper;
import org.commonjava.maven.galley.maven.GalleyMavenException;
import org.commonjava.maven.galley.maven.model.view.meta.MavenMetadataView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="range-resolver")
@Singleton
public class RangeResolver
implements Manipulator {
    private static final Logger logger = LoggerFactory.getLogger(RangeResolver.class);
    private ManipulationSession session;
    private final GalleyAPIWrapper readerWrapper;

    @Inject
    public RangeResolver(GalleyAPIWrapper readerWrapper) {
        this.readerWrapper = readerWrapper;
    }

    @Override
    public void init(ManipulationSession session) {
        this.session = session;
        session.setState(new RangeResolverState(session.getUserProperties()));
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects) throws ManipulationException {
        RangeResolverState state = this.session.getState(RangeResolverState.class);
        if (!(this.session.isEnabled() && this.session.anyStateEnabled(State.activeByDefault) && state != null && state.isEnabled())) {
            logger.debug("{}: Nothing to do!", (Object)this.getClass().getSimpleName());
            return Collections.emptySet();
        }
        HashSet<Project> changed = new HashSet<Project>(projects.size());
        for (Project p : projects) {
            try {
                if (p.getModel().getBuild() != null) {
                    if (p.getModel().getBuild().getPluginManagement() != null) {
                        p.getModel().getBuild().getPluginManagement().getPlugins().stream().filter(plugin -> StringUtils.isNotEmpty(plugin.getVersion())).forEach(plugin -> this.handleVersionWithRange(projects, (Plugin)plugin));
                    }
                    p.getModel().getBuild().getPlugins().stream().filter(plugin -> StringUtils.isNotEmpty(plugin.getVersion())).forEach(plugin -> this.handleVersionWithRange(projects, (Plugin)plugin));
                }
                if (p.getModel().getDependencyManagement() != null) {
                    p.getModel().getDependencyManagement().getDependencies().stream().filter(dependency -> StringUtils.isNotEmpty(dependency.getVersion())).forEach(dependency -> this.handleVersionWithRange(projects, (Dependency)dependency));
                }
                p.getModel().getDependencies().stream().filter(dependency -> StringUtils.isNotEmpty(dependency.getVersion())).forEach(dependency -> this.handleVersionWithRange(projects, (Dependency)dependency));
                p.getModel().getProfiles().stream().filter(profile -> profile.getDependencyManagement() != null).forEach(profile -> {
                    profile.getDependencyManagement().getDependencies().stream().filter(dependency -> StringUtils.isNotEmpty(dependency.getVersion())).forEach(dependency -> this.handleVersionWithRange(projects, (Dependency)dependency));
                    profile.getDependencies().stream().filter(dependency -> StringUtils.isNotEmpty(dependency.getVersion())).forEach(dependency -> this.handleVersionWithRange(projects, (Dependency)dependency));
                    if (profile.getBuild() != null) {
                        if (profile.getBuild().getPluginManagement() != null) {
                            profile.getBuild().getPluginManagement().getPlugins().stream().filter(plugin -> StringUtils.isNotEmpty(plugin.getVersion())).forEach(plugin -> this.handleVersionWithRange(projects, (Plugin)plugin));
                        }
                        profile.getBuild().getPlugins().stream().filter(plugin -> StringUtils.isNotEmpty(plugin.getVersion())).forEach(plugin -> this.handleVersionWithRange(projects, (Plugin)plugin));
                    }
                });
                changed.add(p);
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof ManipulationException) {
                    throw (ManipulationException)e.getCause();
                }
                throw e;
            }
        }
        return changed;
    }

    private void handleVersionWithRange(List<Project> projects, Plugin p) {
        String version = PropertyResolver.resolvePropertiesUnchecked(this.session, projects, p.getVersion());
        try {
            VersionRange versionRange = VersionRange.createFromVersionSpec(version);
            if (versionRange.hasRestrictions()) {
                String groupId = PropertyResolver.resolvePropertiesUnchecked(this.session, projects, p.getGroupId());
                String artifactId = PropertyResolver.resolvePropertiesUnchecked(this.session, projects, p.getArtifactId());
                List<ArtifactVersion> versions = this.getVersions(new SimpleProjectRef(groupId, artifactId));
                ArtifactVersion result = versionRange.matchVersion(versions);
                logger.debug("Resolved range for plugin {} got versionRange {} and potential replacement of {}", p, versionRange, result);
                if (result != null) {
                    p.setVersion(result.toString());
                } else {
                    logger.warn("Unable to find replacement for range.");
                }
            }
        }
        catch (InvalidVersionSpecificationException e) {
            throw new ManipulationUncheckedException(new ManipulationException("Invalid range", e));
        }
    }

    private void handleVersionWithRange(List<Project> projects, Dependency d) {
        String version = PropertyResolver.resolvePropertiesUnchecked(this.session, projects, d.getVersion());
        try {
            VersionRange versionRange = VersionRange.createFromVersionSpec(version);
            if (versionRange.hasRestrictions()) {
                String groupId = PropertyResolver.resolvePropertiesUnchecked(this.session, projects, d.getGroupId());
                String artifactId = PropertyResolver.resolvePropertiesUnchecked(this.session, projects, d.getArtifactId());
                List<ArtifactVersion> versions = this.getVersions(new SimpleProjectRef(groupId, artifactId));
                ArtifactVersion result = versionRange.matchVersion(versions);
                logger.debug("Resolved range for dependency {} got versionRange {} and potential replacement of {}", d, versionRange, result);
                if (result != null) {
                    d.setVersion(result.toString());
                } else {
                    logger.warn("Unable to find replacement for range");
                }
            }
        }
        catch (InvalidVersionSpecificationException e) {
            throw new ManipulationUncheckedException(new ManipulationException("Invalid range", e));
        }
    }

    private List<ArtifactVersion> getVersions(ProjectRef ga) {
        MavenMetadataView mavenMetadataView;
        try {
            mavenMetadataView = this.readerWrapper.readMetadataView(ga);
        }
        catch (GalleyMavenException e) {
            throw new ManipulationUncheckedException(new ManipulationException("Caught Galley exception processing artifact", e));
        }
        return mavenMetadataView.resolveXPathToAggregatedStringList("/metadata/versioning/versions/version", true, -1).stream().distinct().map(DefaultArtifactVersion::new).collect(Collectors.toList());
    }

    @Override
    public int getExecutionIndex() {
        return 2;
    }
}

