/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.model.SimpleScopedArtifactRef;
import org.commonjava.maven.ext.common.util.ProfileUtils;
import org.commonjava.maven.ext.common.util.WildcardMap;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.impl.Manipulator;
import org.commonjava.maven.ext.core.state.RelocationState;
import org.commonjava.maven.ext.core.util.DependencyPluginUtils;
import org.commonjava.maven.ext.core.util.PluginReference;
import org.commonjava.maven.ext.io.resolver.GalleyAPIWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="relocations-manipulator")
@Singleton
public class RelocationManipulator
implements Manipulator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final GalleyAPIWrapper galleyWrapper;
    private ManipulationSession session;

    @Inject
    public RelocationManipulator(GalleyAPIWrapper galleyWrapper) {
        this.galleyWrapper = galleyWrapper;
    }

    @Override
    public void init(ManipulationSession session) throws ManipulationException {
        this.session = session;
        session.setState(new RelocationState(session.getUserProperties()));
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects) throws ManipulationException {
        RelocationState state = this.session.getState(RelocationState.class);
        if (!this.session.isEnabled() || !state.isEnabled()) {
            this.logger.debug("{}: Nothing to do!", (Object)this.getClass().getSimpleName());
            return Collections.emptySet();
        }
        HashSet<Project> changed = new HashSet<Project>();
        for (Project project : projects) {
            Model model;
            if (!this.apply(project, model = project.getModel())) continue;
            changed.add(project);
        }
        return changed;
    }

    private boolean apply(Project project, Model model) throws ManipulationException {
        boolean result = false;
        RelocationState state = this.session.getState(RelocationState.class);
        WildcardMap<ProjectVersionRef> dependencyRelocations = state.getDependencyRelocations();
        WildcardMap<ProjectVersionRef> pluginRelocations = state.getPluginRelocations();
        this.logger.debug("Applying relocation changes for dependencies ({}) and for plugins ({}) to: {}:{}", dependencyRelocations, pluginRelocations, project.getGroupId(), project.getArtifactId());
        DependencyManagement dependencyManagement = model.getDependencyManagement();
        if (dependencyManagement != null) {
            result = this.updateDependencies(project, dependencyRelocations, project.getResolvedManagedDependencies(this.session));
        }
        result |= this.updateDependencies(project, dependencyRelocations, project.getAllResolvedDependencies(this.session));
        for (Profile profile : ProfileUtils.getProfiles(this.session, model)) {
            dependencyManagement = profile.getDependencyManagement();
            if (dependencyManagement != null) {
                result |= this.updateDependencies(project, dependencyRelocations, project.getResolvedProfileManagedDependencies(this.session).get(profile));
            }
            result |= this.updateDependencies(project, dependencyRelocations, project.getAllResolvedProfileDependencies(this.session).get(profile));
        }
        result |= this.updatePlugins(pluginRelocations, dependencyRelocations, project, project.getResolvedManagedPlugins(this.session));
        result |= this.updatePlugins(pluginRelocations, dependencyRelocations, project, project.getAllResolvedPlugins(this.session));
        for (Profile profile : project.getAllResolvedProfilePlugins(this.session).keySet()) {
            result |= this.updatePlugins(pluginRelocations, dependencyRelocations, project, project.getAllResolvedProfilePlugins(this.session).get(profile));
        }
        for (Profile profile : project.getResolvedProfileManagedPlugins(this.session).keySet()) {
            result |= this.updatePlugins(pluginRelocations, dependencyRelocations, project, project.getResolvedProfileManagedPlugins(this.session).get(profile));
        }
        return result;
    }

    private boolean updateDependencies(Project project, WildcardMap<ProjectVersionRef> relocations, Map<ArtifactRef, Dependency> dependencies) throws ManipulationException {
        HashMap<SimpleScopedArtifactRef, Dependency> postFixUp = new HashMap<SimpleScopedArtifactRef, Dependency>();
        boolean result = false;
        for (int i = 0; i < relocations.size(); ++i) {
            Iterator<ArtifactRef> it = dependencies.keySet().iterator();
            while (it.hasNext()) {
                ArtifactRef pvr = it.next();
                if (!relocations.containsKey(pvr.asProjectRef())) continue;
                ProjectVersionRef relocation = relocations.get(pvr.asProjectRef());
                Dependency dependency = dependencies.get(pvr);
                this.logger.info("For dependency {}, replacing groupId {} by {} and artifactId {} with {}", dependency, dependency.getGroupId(), relocation.getGroupId(), dependency.getArtifactId(), relocation.getArtifactId());
                if (!relocation.getArtifactId().equals("*")) {
                    DependencyPluginUtils.updateString(project, this.session, dependency.getArtifactId(), relocation, relocation.getArtifactId(), d -> dependency.setArtifactId(relocation.getArtifactId()));
                }
                if (relocation.getVersionString().equals("*")) {
                    this.logger.debug("No version alignment to perform for relocation {}", (Object)relocation);
                } else {
                    DependencyPluginUtils.updateString(project, this.session, dependency.getVersion(), relocation, relocation.getVersionString(), d -> dependency.setVersion(relocation.getVersionString()));
                }
                DependencyPluginUtils.updateString(project, this.session, dependency.getGroupId(), relocation, relocation.getGroupId(), d -> dependency.setGroupId(relocation.getGroupId()));
                postFixUp.put(new SimpleScopedArtifactRef(dependency), dependency);
                it.remove();
                result = true;
            }
            dependencies.putAll(postFixUp);
            postFixUp.clear();
        }
        return result;
    }

    private boolean updatePlugins(WildcardMap<ProjectVersionRef> pluginRelocations, WildcardMap<ProjectVersionRef> dependencyRelocations, Project project, Map<ProjectVersionRef, Plugin> pluginMap) throws ManipulationException {
        ProjectVersionRef relocation;
        int i;
        HashMap<SimpleProjectVersionRef, Plugin> postFixUp = new HashMap<SimpleProjectVersionRef, Plugin>();
        boolean result = false;
        List<PluginReference> refs = DependencyPluginUtils.findPluginReferences(this.galleyWrapper, project, pluginMap);
        int size = dependencyRelocations.size();
        for (i = 0; i < size; ++i) {
            for (PluginReference pluginReference : refs) {
                Dependency dependency = new Dependency();
                dependency.setGroupId(pluginReference.getGroupId());
                dependency.setArtifactId(pluginReference.getArtifactId());
                relocation = dependencyRelocations.get(dependency);
                if (relocation == null) continue;
                DependencyPluginUtils.updateString(project, this.session, pluginReference.getGroupId(), relocation, relocation.getGroupId(), d -> pluginReference.groupIdNode.setTextContent(relocation.getGroupId()));
                if (!relocation.getArtifactId().equals("*")) {
                    DependencyPluginUtils.updateString(project, this.session, pluginReference.getArtifactId(), relocation, relocation.getArtifactId(), d -> pluginReference.artifactIdNode.setTextContent(relocation.getArtifactId()));
                }
                if (pluginReference.versionNode != null) {
                    if (relocation.getVersionString().equals("*")) {
                        this.logger.debug("No version alignment to perform for relocation {}", (Object)relocation);
                    } else {
                        DependencyPluginUtils.updateString(project, this.session, pluginReference.versionNode.getTextContent(), relocation, relocation.getVersionString(), d -> pluginReference.versionNode.setTextContent(relocation.getVersionString()));
                    }
                }
                pluginReference.container.setConfiguration(DependencyPluginUtils.getConfigXml(this.galleyWrapper, pluginReference.groupIdNode));
                this.logger.debug("Update plugin: set {} to {}", (Object)relocation, (Object)pluginReference);
                result = true;
            }
        }
        for (i = 0; i < pluginRelocations.size(); ++i) {
            Iterator<ProjectVersionRef> it = pluginMap.keySet().iterator();
            while (it.hasNext()) {
                ProjectVersionRef pvr = it.next();
                if (!pluginRelocations.containsKey(pvr.asProjectRef())) continue;
                Plugin plugin = pluginMap.get(pvr);
                relocation = pluginRelocations.get(pvr.asProjectRef());
                this.logger.info("For plugin {}, replacing groupId {} by {} and artifactId {} with {}", plugin.getId(), plugin.getGroupId(), relocation.getGroupId(), plugin.getArtifactId(), relocation.getArtifactId());
                if (!relocation.getArtifactId().equals("*")) {
                    DependencyPluginUtils.updateString(project, this.session, plugin.getArtifactId(), relocation, relocation.getArtifactId(), d -> plugin.setArtifactId(relocation.getArtifactId()));
                }
                if (relocation.getVersionString().equals("*")) {
                    this.logger.debug("No version alignment to perform for relocation {}", (Object)relocation);
                } else {
                    DependencyPluginUtils.updateString(project, this.session, plugin.getVersion(), relocation, relocation.getVersionString(), d -> plugin.setVersion(relocation.getVersionString()));
                }
                DependencyPluginUtils.updateString(project, this.session, plugin.getGroupId(), relocation, relocation.getGroupId(), d -> plugin.setGroupId(relocation.getGroupId()));
                postFixUp.put(new SimpleProjectVersionRef(plugin.getGroupId(), plugin.getArtifactId(), StringUtils.isEmpty(plugin.getVersion()) ? "*" : plugin.getVersion()), plugin);
                it.remove();
                result = true;
            }
            pluginMap.putAll(postFixUp);
            postFixUp.clear();
        }
        return result;
    }

    @Override
    public int getExecutionIndex() {
        return 7;
    }
}

