/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.state;

import java.util.List;
import java.util.Properties;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.ext.core.state.State;
import org.commonjava.maven.ext.core.util.IdUtils;

public class DependencyInjectionState
implements State {
    private static final String DEPENDENCY_INJECTION_PROPERTY = "dependencyInjection";
    private static final String DEPENDENCY_INJECTION_ANALYZE_PLUGIN_PROPERTY = "dependencyInjectionAnalyzeIgnoreUnused";
    private List<ProjectVersionRef> dependencyInjection;
    private boolean addIgnoreUnusedAnalzyePlugin;

    public DependencyInjectionState(Properties userProps) {
        this.initialise(userProps);
    }

    @Override
    public void initialise(Properties userProps) {
        this.dependencyInjection = IdUtils.parseGAVs(userProps.getProperty(DEPENDENCY_INJECTION_PROPERTY));
        this.addIgnoreUnusedAnalzyePlugin = Boolean.parseBoolean(userProps.getProperty(DEPENDENCY_INJECTION_ANALYZE_PLUGIN_PROPERTY, "false"));
    }

    @Override
    public boolean isEnabled() {
        return this.dependencyInjection != null && !this.dependencyInjection.isEmpty();
    }

    public List<ProjectVersionRef> getDependencyInjection() {
        return this.dependencyInjection;
    }

    public boolean isAddIgnoreUnusedAnalzyePlugin() {
        return this.addIgnoreUnusedAnalzyePlugin;
    }
}

