/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.state;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.util.WildcardMap;
import org.commonjava.maven.ext.core.state.State;
import org.commonjava.maven.ext.core.util.PropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelocationState
implements State {
    public static final String DEPENDENCY_RELOCATIONS = "dependencyRelocations.";
    public static final String PLUGIN_RELOCATIONS = "pluginRelocations.";
    private static final Logger logger = LoggerFactory.getLogger(RelocationState.class);
    private final WildcardMap<ProjectVersionRef> dependencyRelocations = new WildcardMap();
    private final WildcardMap<ProjectVersionRef> pluginRelocations = new WildcardMap();

    public RelocationState(Properties userProps) throws ManipulationException {
        this.initialise(userProps);
    }

    @Override
    public void initialise(Properties userProps) throws ManipulationException {
        Map<String, String> depPropRelocs = PropertiesUtils.getPropertiesByPrefix(userProps, DEPENDENCY_RELOCATIONS);
        Map<String, String> pluginPropRelocs = PropertiesUtils.getPropertiesByPrefix(userProps, PLUGIN_RELOCATIONS);
        this.processProperties(this.dependencyRelocations, depPropRelocs);
        this.processProperties(this.pluginRelocations, pluginPropRelocs);
    }

    private void processProperties(WildcardMap<ProjectVersionRef> map, Map<String, String> propRelocs) throws ManipulationException {
        for (Map.Entry<String, String> entry : propRelocs.entrySet()) {
            String[] split = entry.getKey().split(":", 3);
            if (split.length != 3) {
                throw new ManipulationException("Incorrect relocation format; should be <..> : [ <...> ] @ <..> : [ <...> ]", new Object[0]);
            }
            String groupId = split[0];
            String newArtifactId = split[2];
            if ((split = split[1].split("@")).length != 2) {
                throw new ManipulationException("Incorrect relocation format for oldArtifactId/newGroupdId; should be <..> : [ <...> ] @ <..> : [ <...> ]", new Object[0]);
            }
            String artifactId = split[0];
            String newGroupId = split[1];
            if (StringUtils.isEmpty(artifactId) != StringUtils.isEmpty(newArtifactId)) {
                throw new ManipulationException("Incorrect relocation format for artifactId ({} : {}); should be <..> : [ <...> ] @ <..> : [ <...> ]", artifactId, newArtifactId);
            }
            if (StringUtils.isEmpty(artifactId)) {
                artifactId = "*";
            }
            if (StringUtils.isEmpty(newArtifactId)) {
                newArtifactId = "*";
            }
            if (groupId.length() == 0 || newGroupId.length() == 0) {
                throw new ManipulationException("Incorrect relocation format for groupIds ({} : {}); should be <..> : [ <...> ] @ <..> : [ <...> ]", groupId, newGroupId);
            }
            String version = StringUtils.isEmpty(entry.getValue()) ? "*" : entry.getValue();
            logger.debug("Relocation found oldGroupId '{}' : oldArtifactId '{}' -> newGroupId '{}' : newArtifactId '{}' and version '{}' ", groupId, artifactId, newGroupId, newArtifactId, version);
            SimpleProjectRef sp = new SimpleProjectRef(groupId, artifactId);
            map.put(sp, new SimpleProjectVersionRef(newGroupId, newArtifactId, version));
        }
        logger.trace("Wildcard map {}", (Object)map);
    }

    @Override
    public boolean isEnabled() {
        return !this.dependencyRelocations.isEmpty() || !this.pluginRelocations.isEmpty();
    }

    public WildcardMap<ProjectVersionRef> getDependencyRelocations() {
        return this.dependencyRelocations;
    }

    public WildcardMap<ProjectVersionRef> getPluginRelocations() {
        return this.pluginRelocations;
    }
}

