/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.state;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.ext.core.state.State;

public class VersioningState
implements State {
    public static final String VERSION_SUFFIX_SYSPROP = "versionSuffix";
    public static final String INCREMENT_SERIAL_SUFFIX_SYSPROP = "versionIncrementalSuffix";
    public static final String INCREMENT_SERIAL_SUFFIX_PADDING_SYSPROP = "versionIncrementalSuffixPadding";
    public static final String VERSION_SUFFIX_SNAPSHOT_SYSPROP = "versionSuffixSnapshot";
    public static final String VERSION_OSGI_SYSPROP = "versionOsgi";
    public static final String VERSION_OVERRIDE_SYSPROP = "versionOverride";
    public static final String VERSION_SUFFIX_ALT = "versionSuffixAlternatives";
    private String suffix;
    private String incrementalSerialSuffix;
    private boolean preserveSnapshot;
    private boolean osgi;
    private String override;
    private int incrementalSerialSuffixPadding;
    private List<String> suffixAlternatives;
    private List<String> allSuffixes;
    private final Map<ProjectVersionRef, String> versionsByGAV = new HashMap<ProjectVersionRef, String>();
    private Map<ProjectRef, Set<String>> restMetaData;

    public VersioningState(Properties userProps) {
        this.initialise(userProps);
    }

    @Override
    public void initialise(Properties userProps) {
        this.suffix = userProps.getProperty(VERSION_SUFFIX_SYSPROP);
        this.incrementalSerialSuffix = userProps.getProperty(INCREMENT_SERIAL_SUFFIX_SYSPROP);
        this.incrementalSerialSuffixPadding = Integer.parseInt(userProps.getProperty(INCREMENT_SERIAL_SUFFIX_PADDING_SYSPROP, "5"));
        this.preserveSnapshot = Boolean.parseBoolean(userProps.getProperty(VERSION_SUFFIX_SNAPSHOT_SYSPROP));
        this.osgi = Boolean.parseBoolean(userProps.getProperty(VERSION_OSGI_SYSPROP, "true"));
        this.override = userProps.getProperty(VERSION_OVERRIDE_SYSPROP);
        this.suffixAlternatives = Arrays.asList(StringUtils.split(userProps.getProperty(VERSION_SUFFIX_ALT, "redhat".equals(this.getRebuildSuffix()) ? "" : "redhat"), ","));
        this.allSuffixes = new ArrayList<String>();
        if (StringUtils.isNotEmpty(this.getRebuildSuffix())) {
            this.allSuffixes.add(this.getRebuildSuffix());
            this.allSuffixes.addAll(this.getSuffixAlternatives());
        }
    }

    @Override
    public boolean isEnabled() {
        return this.incrementalSerialSuffix != null || this.suffix != null || this.override != null;
    }

    public void setRESTMetadata(Map<ProjectRef, Set<String>> versionStates) {
        this.restMetaData = versionStates;
    }

    public Map<ProjectRef, Set<String>> getRESTMetadata() {
        return this.restMetaData;
    }

    public void setVersionsByGAVMap(Map<ProjectVersionRef, String> versionsByGAV) {
        this.versionsByGAV.putAll(versionsByGAV);
    }

    public boolean hasVersionsByGAV() {
        return !this.versionsByGAV.isEmpty();
    }

    public String getRebuildSuffix() {
        String suffix = "";
        if (!StringUtils.isEmpty(this.getSuffix())) {
            int dashIndex = this.getSuffix().lastIndexOf(45);
            suffix = this.getSuffix().substring(0, dashIndex > 0 ? dashIndex : this.getSuffix().length());
        } else if (!StringUtils.isEmpty(this.getIncrementalSerialSuffix())) {
            suffix = this.getIncrementalSerialSuffix();
        }
        return suffix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getIncrementalSerialSuffix() {
        return this.incrementalSerialSuffix;
    }

    public boolean isPreserveSnapshot() {
        return this.preserveSnapshot;
    }

    public boolean isOsgi() {
        return this.osgi;
    }

    public String getOverride() {
        return this.override;
    }

    public int getIncrementalSerialSuffixPadding() {
        return this.incrementalSerialSuffixPadding;
    }

    public List<String> getSuffixAlternatives() {
        return this.suffixAlternatives;
    }

    public List<String> getAllSuffixes() {
        return this.allSuffixes;
    }

    public Map<ProjectVersionRef, String> getVersionsByGAV() {
        return this.versionsByGAV;
    }
}

