/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Parent;
import org.apache.maven.project.MavenProject;
import org.commonjava.maven.atlas.ident.ref.InvalidRefException;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationUncheckedException;
import org.commonjava.maven.ext.common.model.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IdUtils {
    private static final Logger logger = LoggerFactory.getLogger(IdUtils.class);

    private IdUtils() {
    }

    public static List<ProjectVersionRef> parseGAVs(String value) {
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        String[] gavs = value.split(",");
        ArrayList<ProjectVersionRef> refs = new ArrayList<ProjectVersionRef>();
        for (String gav : gavs) {
            if (!StringUtils.isNotEmpty(gav)) continue;
            if (gav.startsWith("http://") || gav.startsWith("https://")) {
                logger.debug("Found remote file in {}", (Object)gav);
                try {
                    File found = File.createTempFile(UUID.randomUUID().toString(), null);
                    FileUtils.copyURLToFile(new URL(gav), found);
                    String potentialRefs = FileUtils.readFileToString(found, Charset.defaultCharset()).trim().replace("\n", ",");
                    List<ProjectVersionRef> readRefs = IdUtils.parseGAVs(potentialRefs);
                    if (readRefs == null) continue;
                    refs.addAll(readRefs);
                    continue;
                }
                catch (IOException | InvalidRefException e) {
                    throw new ManipulationUncheckedException(e);
                }
            }
            refs.add(SimpleProjectVersionRef.parse(gav));
        }
        return refs;
    }

    public static List<ProjectRef> parseGAs(String value) {
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        String[] gavs = value.split(",");
        ArrayList<ProjectRef> refs = new ArrayList<ProjectRef>();
        for (String gav : gavs) {
            if (!StringUtils.isNotEmpty(gav)) continue;
            if (gav.startsWith("http://") || gav.startsWith("https://")) {
                logger.debug("Found remote file in {}", (Object)gav);
                try {
                    File found = File.createTempFile(UUID.randomUUID().toString(), null);
                    FileUtils.copyURLToFile(new URL(gav), found);
                    String potentialRefs = FileUtils.readFileToString(found, Charset.defaultCharset()).trim().replace("\n", ",");
                    List<ProjectRef> readRefs = IdUtils.parseGAs(potentialRefs);
                    if (readRefs == null) continue;
                    refs.addAll(readRefs);
                    continue;
                }
                catch (IOException | InvalidRefException e) {
                    throw new ManipulationUncheckedException(e);
                }
            }
            refs.add(SimpleProjectRef.parse(gav));
        }
        return refs;
    }

    public static String gav(Project project) {
        return String.format("%s:%s:%s", project.getGroupId(), project.getArtifactId(), project.getVersion());
    }

    public static String ga(MavenProject project) {
        return IdUtils.ga(project.getGroupId(), project.getArtifactId());
    }

    public static String ga(Project project) {
        return IdUtils.ga(project.getGroupId(), project.getArtifactId());
    }

    public static String ga(Parent project) {
        return IdUtils.ga(project.getGroupId(), project.getArtifactId());
    }

    public static String ga(String g, String a) {
        return String.format("%s:%s", g, a);
    }

    public static String gav(String g, String a, String v) {
        return String.format("%s:%s:%s", g, a, v);
    }
}

