/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.util;

import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputLocationTracker;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.ManipulationUncheckedException;
import org.commonjava.maven.ext.core.util.DependencyPluginUtils;
import org.commonjava.maven.ext.io.resolver.GalleyAPIWrapper;
import org.w3c.dom.Node;

public final class PluginReference
implements InputLocationTracker {
    public final ConfigurationContainer container;
    public final Node groupIdNode;
    public final Node artifactIdNode;
    public final Node versionNode;
    private final GalleyAPIWrapper galleyWrapper;

    public PluginReference(GalleyAPIWrapper galleyWrapper, ConfigurationContainer container, Node groupIdNode, Node artifactIdNode, Node versionNode) {
        this.container = container;
        this.groupIdNode = groupIdNode;
        this.artifactIdNode = artifactIdNode;
        this.versionNode = versionNode;
        this.galleyWrapper = galleyWrapper;
    }

    public String toString() {
        return "PluginReference{container=" + this.container + this.nodeToString(this.groupIdNode) + this.nodeToString(this.artifactIdNode) + this.nodeToString(this.versionNode) + '}';
    }

    private String nodeToString(Node node) {
        return node == null ? "" : ", [" + node.getNodeName() + "=" + node.getTextContent() + "]";
    }

    @Override
    public InputLocation getLocation(Object o) {
        throw new ManipulationUncheckedException("Unused", new Object[0]);
    }

    @Override
    public void setLocation(Object o, InputLocation inputLocation) {
        throw new ManipulationUncheckedException("Unused", new Object[0]);
    }

    public String getGroupId() {
        return this.groupIdNode.getTextContent();
    }

    public String getArtifactId() {
        return this.artifactIdNode.getTextContent();
    }

    public String getVersion() {
        return this.versionNode == null ? null : this.versionNode.getTextContent();
    }

    public void setVersion(String version) throws ManipulationException {
        this.versionNode.setTextContent(version);
        this.container.setConfiguration(DependencyPluginUtils.getConfigXml(this.galleyWrapper, this.groupIdNode));
    }
}

