/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.products.model.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.NonNull;
import org.jboss.da.model.rest.DummyVersionComparator;
import org.jboss.da.model.rest.GA;

public class GADiff
implements Comparable<GADiff> {
    @NonNull
    private final GA ga;
    @NonNull
    private final String leftVersion;
    @NonNull
    private final String rightVersion;
    @NonNull
    private final String differenceType;

    @JsonCreator
    public GADiff(@JsonProperty(value="groupId") String groupId, @JsonProperty(value="artifactId") String artifactId, @JsonProperty(value="leftVersion") String leftVersion, @JsonProperty(value="rightVersion") String rightVersion, @JsonProperty(value="differenceType") String differenceType) {
        this.ga = new GA(groupId, artifactId);
        this.leftVersion = leftVersion;
        this.rightVersion = rightVersion;
        this.differenceType = differenceType;
    }

    public GADiff(GA ga, String leftVersion, String rightVersion, String differenceType) {
        this.ga = ga;
        this.leftVersion = leftVersion;
        this.rightVersion = rightVersion;
        this.differenceType = differenceType;
    }

    @JsonIgnore
    public GA getGA() {
        return this.ga;
    }

    public String getGroupId() {
        return this.ga.getGroupId();
    }

    public String getArtifactId() {
        return this.ga.getArtifactId();
    }

    @Override
    public int compareTo(GADiff o) {
        int gaCmp = this.ga.compareTo(o.ga);
        if (gaCmp != 0) {
            return gaCmp;
        }
        gaCmp = DummyVersionComparator.compareVersions(this.leftVersion, o.leftVersion);
        if (gaCmp != 0) {
            return gaCmp;
        }
        return DummyVersionComparator.compareVersions(this.rightVersion, o.rightVersion);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GADiff)) {
            return false;
        }
        GADiff other = (GADiff)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GA this$ga = this.getGA();
        GA other$ga = other.getGA();
        if (this$ga == null ? other$ga != null : !((Object)this$ga).equals(other$ga)) {
            return false;
        }
        String this$leftVersion = this.getLeftVersion();
        String other$leftVersion = other.getLeftVersion();
        if (this$leftVersion == null ? other$leftVersion != null : !this$leftVersion.equals(other$leftVersion)) {
            return false;
        }
        String this$rightVersion = this.getRightVersion();
        String other$rightVersion = other.getRightVersion();
        if (this$rightVersion == null ? other$rightVersion != null : !this$rightVersion.equals(other$rightVersion)) {
            return false;
        }
        String this$differenceType = this.getDifferenceType();
        String other$differenceType = other.getDifferenceType();
        return !(this$differenceType == null ? other$differenceType != null : !this$differenceType.equals(other$differenceType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GADiff;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GA $ga = this.getGA();
        result = result * 59 + ($ga == null ? 43 : ((Object)$ga).hashCode());
        String $leftVersion = this.getLeftVersion();
        result = result * 59 + ($leftVersion == null ? 43 : $leftVersion.hashCode());
        String $rightVersion = this.getRightVersion();
        result = result * 59 + ($rightVersion == null ? 43 : $rightVersion.hashCode());
        String $differenceType = this.getDifferenceType();
        result = result * 59 + ($differenceType == null ? 43 : $differenceType.hashCode());
        return result;
    }

    @NonNull
    public String getLeftVersion() {
        return this.leftVersion;
    }

    @NonNull
    public String getRightVersion() {
        return this.rightVersion;
    }

    @NonNull
    public String getDifferenceType() {
        return this.differenceType;
    }
}

