/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.scm;

import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.ScmProviderRepositoryWithHost;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

@Component(role=ScmRepositoryConfigurator.class, instantiationStrategy="singleton")
public class DefaultScmRepositoryConfigurator
extends AbstractLogEnabled
implements ScmRepositoryConfigurator {
    @Requirement
    private ScmManager scmManager;
    @Requirement(hint="mng-4384")
    private SecDispatcher secDispatcher;

    @Override
    public ScmRepository getConfiguredRepository(ReleaseDescriptor releaseDescriptor, Settings settings) throws ScmRepositoryException, NoSuchScmProviderException {
        String url = releaseDescriptor.getScmSourceUrl();
        return this.getConfiguredRepository(url, releaseDescriptor, settings);
    }

    @Override
    public ScmRepository getConfiguredRepository(String url, ReleaseDescriptor releaseDescriptor, Settings settings) throws ScmRepositoryException, NoSuchScmProviderException {
        String username = releaseDescriptor.getScmUsername();
        String password = releaseDescriptor.getScmPassword();
        String privateKey = releaseDescriptor.getScmPrivateKey();
        String passphrase = releaseDescriptor.getScmPrivateKeyPassPhrase();
        ScmRepository repository = this.scmManager.makeScmRepository(url);
        ScmProviderRepository scmRepo = repository.getProviderRepository();
        scmRepo.setPersistCheckout(false);
        if (settings != null) {
            Server server = null;
            if (releaseDescriptor.getScmId() != null) {
                server = settings.getServer(releaseDescriptor.getScmId());
            }
            if (server == null && repository.getProviderRepository() instanceof ScmProviderRepositoryWithHost) {
                ScmProviderRepositoryWithHost repositoryWithHost = (ScmProviderRepositoryWithHost)repository.getProviderRepository();
                String host = repositoryWithHost.getHost();
                int port = repositoryWithHost.getPort();
                if (port > 0) {
                    host = host + ":" + port;
                }
                server = settings.getServer(host);
            }
            if (server != null) {
                if (username == null) {
                    username = server.getUsername();
                }
                if (password == null) {
                    password = this.decrypt(server.getPassword(), server.getId());
                }
                if (privateKey == null) {
                    privateKey = server.getPrivateKey();
                }
                if (passphrase == null) {
                    passphrase = this.decrypt(server.getPassphrase(), server.getId());
                }
            }
        }
        if (!StringUtils.isEmpty(username)) {
            scmRepo.setUser(username);
        }
        if (!StringUtils.isEmpty(password)) {
            scmRepo.setPassword(password);
        }
        if (scmRepo instanceof ScmProviderRepositoryWithHost) {
            ScmProviderRepositoryWithHost repositoryWithHost = (ScmProviderRepositoryWithHost)scmRepo;
            if (!StringUtils.isEmpty(privateKey)) {
                repositoryWithHost.setPrivateKey(privateKey);
            }
            if (!StringUtils.isEmpty(passphrase)) {
                repositoryWithHost.setPassphrase(passphrase);
            }
        }
        if ("svn".equals(repository.getProvider())) {
            String branchBase;
            SvnScmProviderRepository svnRepo = (SvnScmProviderRepository)repository.getProviderRepository();
            String tagBase = releaseDescriptor.getScmTagBase();
            if (!StringUtils.isEmpty(tagBase)) {
                svnRepo.setTagBase(tagBase);
            }
            if (!StringUtils.isEmpty(branchBase = releaseDescriptor.getScmBranchBase())) {
                svnRepo.setBranchBase(branchBase);
            }
        }
        return repository;
    }

    private String decrypt(String str, String server) {
        try {
            return this.secDispatcher.decrypt(str);
        }
        catch (SecDispatcherException e) {
            String msg = "Failed to decrypt password/passphrase for server " + server + ", using auth token as is: " + e.getMessage();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().warn(msg, e);
            } else {
                this.getLogger().warn(msg);
            }
            return str;
        }
    }

    @Override
    public ScmProvider getRepositoryProvider(ScmRepository repository) throws NoSuchScmProviderException {
        return this.scmManager.getProviderByRepository(repository);
    }

    public void setScmManager(ScmManager scmManager) {
        this.scmManager = scmManager;
    }
}

