/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.cli;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.profile.DefaultProfileActivationContext;
import org.apache.maven.model.profile.ProfileSelector;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsUtils;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.InvalidRefException;
import org.commonjava.maven.ext.cli.ManifestVersionProvider;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.SimpleScopedArtifactRef;
import org.commonjava.maven.ext.core.ManipulationManager;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.impl.RESTCollector;
import org.commonjava.maven.ext.core.util.PropertiesUtils;
import org.commonjava.maven.ext.io.ConfigIO;
import org.commonjava.maven.ext.io.PomIO;
import org.commonjava.maven.ext.io.rest.RestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="PME", description={"CLI to run PME"}, mixinStandardHelpOptions=true, exitCodeOnInvalidInput=10, versionProvider=ManifestVersionProvider.class)
public class Cli
implements Callable<Integer> {
    private static final File DEFAULT_GLOBAL_SETTINGS_FILE = new File(System.getProperty("maven.home"), "conf" + File.separator + "settings.xml");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ManipulationSession session;
    private ManipulationManager manipulationManager;
    private PomIO pomIO;
    private PlexusContainer container;
    @CommandLine.Option(names={"-f", "--file"}, description={"POM File"})
    private File target = new File(System.getProperty("user.dir"), "pom.xml");
    @CommandLine.Option(names={"-s", "--settings"}, description={"Optional settings.xml file"})
    private File settings;
    @CommandLine.Option(names={"-l", "--log"}, description={"Optional file to log output to"})
    private String logFile;
    @CommandLine.Option(names={"-D"}, mapFallbackValue="true", description={"Pass Java Properties (default value ${MAP-FALLBACK-VALUE})"})
    private Properties userProps;
    @CommandLine.Option(names={"-P", "--activeProfiles"}, description={"Comma separated list of active profiles."}, split=",")
    private final Set<String> profiles = new HashSet<String>();
    @CommandLine.Option(names={"-q", "--quiet"}, description={"Enable quiet logging (warn/error level)"})
    boolean quiet;
    @CommandLine.Option(names={"-d", "--debug"}, description={"Enable debug logging"})
    boolean debug;
    @CommandLine.Option(names={"-t", "--trace"}, description={"Enable trace logging"})
    boolean trace;
    @CommandLine.Option(names={"-p", "--printProjectDeps"}, description={"Print project dependencies"})
    boolean printProjectDeps;
    @CommandLine.Option(names={"--printManipulatorOrder"}, description={"Print current manipulator order"})
    boolean printManipulatorOrder;

    public static void main(String[] args) {
        System.exit(new Cli().run(args));
    }

    public int run(String[] args) {
        CommandLine cl = new CommandLine(this);
        cl.setUsageHelpAutoWidth(true);
        cl.setExecutionStrategy(new CommandLine.RunAll());
        cl.setOverwrittenOptionsAllowed(true);
        return cl.execute(args);
    }

    @Override
    public Integer call() {
        this.createSession(this.target, this.settings);
        boolean runningInContainer = this.runningInContainer();
        Logger rootLogger = LoggerFactory.getLogger("ROOT");
        ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)rootLogger;
        if (this.logFile != null) {
            if (runningInContainer) {
                this.logger.error("Disabling log file as running in container!");
            } else {
                LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                loggerContext.reset();
                PatternLayoutEncoder ple = new PatternLayoutEncoder();
                ple.setPattern("%level %logger{36} %msg%n");
                ple.setContext(loggerContext);
                ple.start();
                FileAppender<ILoggingEvent> fileAppender = new FileAppender<ILoggingEvent>();
                fileAppender.setEncoder(ple);
                fileAppender.setContext(loggerContext);
                fileAppender.setName("fileLogging");
                fileAppender.setAppend(false);
                fileAppender.setFile(this.logFile);
                fileAppender.start();
                root.addAppender((Appender<ILoggingEvent>)fileAppender);
                root.setLevel(Level.INFO);
            }
        }
        if (this.trace) {
            root.setLevel(Level.TRACE);
        }
        if (this.debug) {
            root.setLevel(Level.DEBUG);
        }
        if (this.quiet) {
            root.setLevel(Level.WARN);
        }
        if (!this.session.isEnabled()) {
            this.logger.info("Manipulation engine disabled via command-line option");
            return 0;
        }
        if (new File(this.target.getParentFile(), ManipulationManager.MARKER_FILE).exists() && !this.printManipulatorOrder && !this.printProjectDeps) {
            this.logger.info("Skipping manipulation as previous execution found.");
            return 0;
        }
        try {
            PropertiesUtils.handleConfigPrecedence(this.session.getUserProperties(), new ConfigIO().parse(this.target.getParentFile()));
        }
        catch (ManipulationException e) {
            this.logger.error("POM Manipulation failed: Unable to read config file ", e);
            return 10;
        }
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Using local repository {}{} and found global settings file in {} with contents {}{} and user settings file in {} with contents {}{}", System.lineSeparator(), this.session.getLocalRepository(), DEFAULT_GLOBAL_SETTINGS_FILE, System.lineSeparator(), DEFAULT_GLOBAL_SETTINGS_FILE.exists() ? FileUtils.readFileToString(DEFAULT_GLOBAL_SETTINGS_FILE, StandardCharsets.UTF_8) : "** File does not exist **", this.settings, System.lineSeparator(), this.settings != null && this.settings.exists() ? FileUtils.readFileToString(this.settings, StandardCharsets.UTF_8) : "** File does not exist **");
            }
            this.manipulationManager.init(this.session);
            if (!this.profiles.isEmpty()) {
                this.session.getActiveProfiles().addAll(this.profiles);
                this.logger.debug("Setting active profiles of {}", (Object)this.profiles);
            } else {
                this.logger.debug("NOT activating any profiles.");
            }
            if (this.printProjectDeps) {
                this.session.getUserProperties().put("versionSuffixSnapshot", "true");
                this.session.reinitialiseStates();
                List ts = RESTCollector.establishAllDependencies(this.session, this.pomIO.parseProject(this.session.getPom()), this.profiles).stream().sorted().collect(Collectors.toList());
                System.out.format("Found %d dependencies%n", ts.size());
                System.out.format("\u001b[32m%-80s%-20s%-20s%-20s\u001b[0m%n", StringUtils.center("GAV", 60), "TYPE", "CLASSIFIER", "SCOPE");
                for (ArtifactRef a : ts) {
                    if (!(a instanceof SimpleScopedArtifactRef)) continue;
                    boolean isPlugin = "maven-plugin".equals(a.getTypeAndClassifier().getType());
                    String scope = ((SimpleScopedArtifactRef)a).getScope() == null ? "compile" : ((SimpleScopedArtifactRef)a).getScope();
                    System.out.format("%-80s%-20s%-20s%-20s%n", a.asProjectVersionRef(), a.getTypeAndClassifier().getType(), a.getTypeAndClassifier().getClassifier() == null ? "" : a.getTypeAndClassifier().getClassifier(), isPlugin ? "" : scope);
                }
            } else if (this.printManipulatorOrder) {
                System.out.println("\u001b[32mManipulator order is:\u001b[0m");
                this.manipulationManager.getOrderedManipulators().forEach(m -> System.out.format("%-20s%-40s%n", StringUtils.center(String.valueOf(m.getExecutionIndex()), 20), m.getClass().getSimpleName()));
            } else {
                this.manipulationManager.scanAndApply(this.session);
            }
        }
        catch (RestException e) {
            this.logger.error("REST communication with {} failed. {}", (Object)this.userProps.getProperty("restURL"), (Object)e.getMessage());
            this.logger.trace("Exception trace is", e);
            return 100;
        }
        catch (ManipulationException e) {
            this.logger.error("POM Manipulation failed; original error is: {}", (Object)e.getMessage(), (Object)e);
            return 10;
        }
        catch (InvalidRefException e) {
            this.logger.error("POM Manipulation failed; original error is: {}", (Object)e.getMessage(), (Object)e);
            return 10;
        }
        catch (Exception e) {
            this.logger.error("POM Manipulation failed.", e);
            return 100;
        }
        return 0;
    }

    private void createSession(File target, File settings) {
        try {
            DefaultContainerConfiguration config = new DefaultContainerConfiguration();
            config.setClassPathScanning("on");
            config.setComponentVisibility("global");
            config.setName("PME-CLI");
            this.container = new DefaultPlexusContainer(config);
            this.pomIO = this.container.lookup(PomIO.class);
            this.session = this.container.lookup(ManipulationSession.class);
            this.manipulationManager = this.container.lookup(ManipulationManager.class);
            MavenExecutionRequest req = new DefaultMavenExecutionRequest().setSystemProperties(System.getProperties()).setUserProperties(this.userProps).setRemoteRepositories(Collections.emptyList());
            MavenArtifactRepository ar = null;
            if (settings == null) {
                File mavenHome = new File(System.getProperty("user.home"), ".m2");
                this.settings = settings = new File(mavenHome, "settings.xml");
                ar = new MavenArtifactRepository();
                ar.setUrl(Paths.get(mavenHome.getAbsolutePath(), "repository").toUri().toString());
                req.setLocalRepository(ar);
            }
            req.setUserSettingsFile(settings);
            req.setGlobalSettingsFile(settings);
            MavenExecutionRequestPopulator executionRequestPopulator = this.container.lookup(MavenExecutionRequestPopulator.class);
            executionRequestPopulator.populateFromSettings(req, this.parseSettings(settings));
            executionRequestPopulator.populateDefaults(req);
            if (ar != null) {
                ar.setUrl(req.getLocalRepositoryPath().toURI().toString());
            }
            if (this.userProps != null && this.userProps.containsKey("maven.repo.local")) {
                if (ar == null) {
                    ar = new MavenArtifactRepository();
                }
                ar.setUrl(Paths.get(this.userProps.getProperty("maven.repo.local"), new String[0]).toUri().toString());
                req.setLocalRepository(ar);
            }
            MavenSession mavenSession = new MavenSession(this.container, null, req, new DefaultMavenExecutionResult());
            mavenSession.getRequest().setPom(target);
            this.session.setMavenSession(mavenSession);
        }
        catch (PlexusContainerException | ComponentLookupException e) {
            this.logger.debug("Caught problem instantiating ", e);
            System.err.println("Unable to start Cli subsystem");
            System.exit(100);
        }
        catch (SettingsBuildingException e) {
            this.logger.debug("Caught problem parsing settings file ", e);
            System.err.println("Unable to parse settings.xml file");
            System.exit(100);
        }
        catch (MavenExecutionRequestPopulationException e) {
            this.logger.debug("Caught problem populating maven request from settings file ", e);
            System.err.println("Unable to create maven execution request from settings.xml file");
            System.exit(100);
        }
    }

    private Settings parseSettings(File settings) throws ComponentLookupException, SettingsBuildingException {
        DefaultSettingsBuildingRequest settingsRequest = new DefaultSettingsBuildingRequest();
        settingsRequest.setUserSettingsFile(settings);
        settingsRequest.setGlobalSettingsFile(DEFAULT_GLOBAL_SETTINGS_FILE);
        settingsRequest.setUserProperties(this.session.getUserProperties());
        settingsRequest.setSystemProperties(System.getProperties());
        SettingsBuilder settingsBuilder = this.container.lookup(SettingsBuilder.class);
        SettingsBuildingResult settingsResult = settingsBuilder.build(settingsRequest);
        Settings effectiveSettings = settingsResult.getEffectiveSettings();
        ProfileSelector profileSelector = this.container.lookup(ProfileSelector.class);
        DefaultProfileActivationContext profileActivationContext = new DefaultProfileActivationContext().setActiveProfileIds(effectiveSettings.getActiveProfiles());
        ArrayList<org.apache.maven.model.Profile> modelProfiles = new ArrayList<org.apache.maven.model.Profile>();
        for (Profile profile : effectiveSettings.getProfiles()) {
            modelProfiles.add(SettingsUtils.convertFromSettingsProfile(profile));
        }
        List<org.apache.maven.model.Profile> activeModelProfiles = profileSelector.getActiveProfiles(modelProfiles, profileActivationContext, modelProblemCollectorRequest -> {});
        ArrayList<String> activeProfiles = new ArrayList<String>();
        for (org.apache.maven.model.Profile profile : activeModelProfiles) {
            activeProfiles.add(profile.getId());
        }
        effectiveSettings.setActiveProfiles(activeProfiles);
        return effectiveSettings;
    }

    private boolean runningInContainer() {
        Path cgroup = Paths.get(Cli.getCGroups(), new String[0]);
        boolean result = false;
        if (Files.isReadable(cgroup)) {
            try (Stream<String> stream = Files.lines(cgroup);){
                result = stream.anyMatch(line -> line.contains("docker") || line.contains("kubepods"));
            }
            catch (Exception e) {
                this.logger.error("Unable to determine if running in a container", e);
            }
        }
        if (!result) {
            result = System.getenv().containsKey("container");
        }
        return result;
    }

    private static String getCGroups() {
        return "/proc/1/cgroup";
    }
}

